<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Pancake
 *
 * A simple, fast, self-hosted invoicing application.
 *
 * This is the French translation for Pancake.
 *
 * @package     Pancake
 * @author      ahouin - https://webmarksolutions.ca
 * @author      Anas AIT ALI <contact@aitali.co> - http://aitali.co
 * @author      Bruno De Barros <bruno@terraduo.com> - https://terraduo.com
 * @author      Damien Dupré - https://github.com/kennedyabitbol
 * @author      Pancake Payments <support@pancakeapp.com> - https://www.pancakeapp.com
 * @copyright   Copyright (c) 2016, Pancake Payments
 * @license     https://www.pancakeapp.com/license
 * @link        https://www.pancakeapp.com
 * @since       Version 4.11.22
 */

// ------------------------------------------------------------------------

$lang = array (
  'global:overview' => 'Vue d\'ensemble',
  'global:error' => 'Erreur',
  'global:pancakeby7am' => 'Pancake :1',
  'global:allrelatedmediacopyright' => 'Pancake et tous les médias liés sont sous copyright :1 :2',
  'global:insecure_action' => 'Une action non sécurisé a été interceptée',
  'global:disabled_in_demo' => 'Certaines fonctionnalités de cette page sont désactivées pour la démo.',
  'global:estimates' => 'Devis',
  'global:estimate' => 'Devis',
  'global:incomplete_tasks' => 'Tâches incomplètes',
  'global:completed_tasks' => 'Tâches achevées',
  'global:projects' => 'Projets',
  'global:tickets' => 'Billets',
  'global:project' => 'Projet',
  'global:upload_failed' => 'Il y a eu un problème pour télécharger votre fichier. Veuillez réessayer. Si le problème persiste , s\'il vous plaît contacter support@pancakeapp.com.',
  'global:upload_not_allowed' => 'Le type de fichier du ficher que vous tentez de télécharger n\'est pas autorisé. Si vous avez besoin de télécharger un fichier de ce type , s\'il vous plaît compressez-le dans une archive .zip ou tout autre format archive que vous trouverez approprié.',
  'global:copied' => 'Copié',
  'global:sentbutunpaid' => 'Envoyé mais non payé',
  'global:task' => 'Tâche',
  'global:clients' => 'Clients',
  'global:access_denied' => 'Accès refusé',
  'global:users' => 'Utilisateurs',
  'global:send_to_client' => 'Envoyer au client',
  'global:emailsent' => 'Votre courriel a été envoyé!',
  'global:yes' => 'Oui',
  'global:no' => 'Non',
  'global:notyetsent' => 'Pas encore envoyé au client',
  'global:dontshowagain' => 'Ne plus afficher ce message',
  'global:enable' => 'Activer',
  'global:is_enabled' => 'Activé',
  'global:is_completed' => 'Terminé',
  'global:Y' => 'O',
  'global:N' => 'N',
  'global:notes' => 'Notes',
  'global:description' => 'Description',
  'global:backtoadmin' => 'Retour dans la partie Admin',
  'global:type' => 'Type',
  'global:name' => 'Nom complet',
  'global:first_name' => 'Prénom',
  'global:last_name' => 'Nom',
  'global:company' => 'Entreprise',
  'global:for' => 'pour',
  'global:from' => 'de',
  'global:phone' => 'Téléphone',
  'global:email' => 'Courriel',
  'global:contacts' => 'Contacts',
  'global:week' => 'Hebdomadaire',
  'global:na' => 'N/D',
  'global:quarterly' => 'Trimestriel',
  'global:every_six_months' => 'Bi-annuel',
  'global:statistics' => 'Statistiques',
  'global:biyearly' => 'Tous les deux ans',
  'global:month' => 'Mensuel',
  'global:year' => 'Annuel',
  'global:fax' => 'Fax',
  'global:mobile' => 'Mobile',
  'global:address' => 'Adresse',
  'global:api_key' => 'Clé API',
  'global:website' => 'Site Web',
  'global:action' => 'Action',
  'global:items' => 'Éléments',
  'global:reusableinvoiceitems' => 'Élément de facturation réutilisable',
  'global:reusableinvoiceitems_description' => 'Vous devriez utiliser "Élément de facturation réutilisable" lorsque vous voulez réutiliser le même élément dans d\'autres factures. Pour utiliser ces éléments lorsque vous créez ou utilisez une facture, commencez simplement à taper le nom de l\'item que vous avez sauvegardé et le système vous offrira de compléter automatiquement les détails.',
  'global:create_invoice_estimate' => 'Créez des factures et des estimations pour collecter de l\'argent',
  'global:createinvoice' => 'Créer une facture',
  'global:paid' => 'Payée',
  'global:unpaid' => 'Impayée',
  'global:overdue' => 'En retard',
  'global:time_entries' => 'Saisies de temps',
  'global:invoices' => 'Factures',
  'global:invoice' => 'Facture',
  'global:tasks' => 'Tâches',
  'global:dashboard' => 'Tableau de bord',
  'global:settings' => 'Paramètres',
  'global:plugins' => 'Extensions',
  'global:installed' => 'Installé',
  'global:changepassword' => 'Changer le mot de passe',
  'global:logout' => 'Déconnexion',
  'global:status' => 'Statut',
  'global:client' => 'Client',
  'global:user' => 'Utilisateur',
  'global:title' => 'Titre',
  'global:subtitle' => 'Sous-titre',
  'global:to' => 'À (pour utiliser plusieurs adresses, séparez-les par des virgules)',
  'global:subject' => 'Sujet',
  'global:thanks' => 'Merci',
  'global:proposals' => 'Propositions',
  'global:proposal' => 'Proposition',
  'global:reports' => 'Rapports',
  'global:item' => 'Élément',
  'global:report' => 'Rapport',
  'global:saveandinsert' => 'Sauvegarder et insérer',
  'global:details' => 'Détails',
  'global:license_key' => 'Clé de license',
  'global:version' => 'Version :1',
  'global:content' => 'Contenu',
  'global:add' => 'Ajouter',
  'global:edit' => 'Modifier',
  'global:resend' => 'Renvoyer',
  'global:sent' => 'Envoyé',
  'global:not_sent' => 'Non envoyé',
  'global:view' => 'Voir',
  'global:delete' => 'Supprimer',
  'global:remove' => 'Retirer',
  'global:sort' => 'Ordre',
  'global:deleteitem' => 'Supprimer l\'élément',
  'global:dragtoreorder' => 'Glissez pour réordonner',
  'global:start' => 'Démarrer',
  'global:stop' => 'Arrêter',
  'global:start_timer' => 'Démarrer le chronomètre',
  'estimates:create' => 'Créer un devis',
  'global:stop_timer' => 'Arrêter le chronomètre',
  'global:created' => 'Créé',
  'global:updated' => 'Mis à jour',
  'global:update' => 'Mise à jour',
  'global:downloadpdf' => 'Télécharger le PDF',
  'global:yesdelete' => 'Oui, supprimer!',
  'global:confirm_emphisised' => 'Il n\'y a aucun retour en arrière possible!',
  'global:color' => 'Couleur',
  'global:save' => 'Enregistrer',
  'global:unknown' => 'Inconnu',
  'global:upload_error' => 'Un problème est survenu lors du téléversement du fichier. Veuillez réessayer.',
  'global:recurring' => 'Récurrent',
  'global:unsent' => 'Non envoyé',
  'global:converttoproject' => 'Convertir en projet',
  'global:converttoinvoice' => 'Convertir en facture',
  'global:viewpdf' => 'Voir le PDF',
  'global:duplicate' => 'Dupliquer',
  'global:urltosend' => 'Voici l\'URL à envoyer : ',
  'global:copytoclipboard' => 'Copier le lien',
  'global:you_need_pancake_cron_job' => 'Pour utiliser des factures récurrentes, vous devez configurer les <a href="https://www.pancakeapp.com/documentation/cron" target="_blank">Tâches Cron de Pancake</a>.',
  'global:quick_links' => 'Liens rapides',
  'global:view_all' => 'Voir tous',
  'global:deleted' => 'Supprimer',
  'global:add_more' => 'Ajout supplémentaire',
  'global:upload_files' => 'Télécharger des fichiers',
  'global:optional_increment' => '<strong>Optionnel</strong> - sera auto-incrémenté',
  'login:ahoy' => 'Ahoy!',
  'login:readytodothis' => 'Prêt ?',
  'login:sup' => 'Quoi de neuf ?',
  'global:actions' => 'Actions',
  'global:select' => '--- Sélectionner ---',
  'global:mark_as_unanswered' => 'Marquer comme sans réponse',
  'global:mark_as_accepted' => 'Marquer comme acceptée',
  'global:mark_as_rejected' => 'Marquer comme rejetée',
  'global:reject_estimate' => 'Refuser le devis',
  'global:accept_estimate' => 'Accepter le devis',
  'global:estimate_rejected' => 'Devis refusé',
  'global:estimate_accepted' => 'Devis accepté',
  'global:reject_proposal' => 'Refuser la proposition',
  'global:accept_proposal' => 'Accepter la proposition',
  'global:proposal_rejected' => 'Proposition refusée',
  'global:proposal_accepted' => 'Proposition acceptée',
  'global:client_area' => 'Espace client',
  'global:admin' => 'Admin',
  'global:all_settings' => 'Tous les paramètres',
  'global:viewable' => 'Visible dans l\'espace client',
  'global:not_viewable' => 'Non visible dans l\'espace client',
  'global:milestones' => 'Étapes',
  'dashboard:collected' => 'Collecté',
  'dashboard:outstanding' => 'Impayé',
  'dashboard:latest_activity' => 'Activité récente',
  'dashboard:these_are_your_upcoming_tasks' => 'Ce sont vos tâches à venir, :1.',
  'dashboard:upcoming_tasks' => 'Tâche à venir',
  'global:timesheets' => 'Feuilles de temps',
  'timesheets:todays' => 'Aujourd\'hui',
  'timesheets:all_users' => 'Tous les utilisateurs',
  'timesheets:rounded_time' => 'Arrondir au plus près :1',
  'timesheets:there_are_no_time_entries' => 'Il n\'y a pas d\'entrée de temps à afficher pour cette période de temps.',
  'login:forgotinstructions' => 'Veuillez entrer votre adresse courriel afin que nous vous envoyions un courriel de réinitialisation du mot de passe.',
  'login:reset' => 'Réinitialiser le mot de passe',
  'login:username' => 'Nom d\'utilisateur',
  'login:password' => 'Mot de passe',
  'login:changepassword' => 'Changer le mot de passe',
  'login:email' => 'Courriel',
  'login:login' => 'Connexion',
  'login:logout' => 'Déconnexion',
  'login:remember' => 'Se souvenir de moi',
  'login:forgot' => 'Mot de passe oublié?',
  'login:cancel' => '&lsaquo; Annuler',
  'groups:edit_title' => 'Modifier le groupe %s',
  'groups:add_title' => 'Ajouter un groupe d\'utilisateurs',
  'clients:title' => 'Tous les clients',
  'clients:filter' => 'Filtrer les clients',
  'clients:add' => 'Ajouter un client',
  'clients:removefilter' => 'Retirer le filtre',
  'clients:edit' => 'Modifier le client',
  'clients:noclienttitle' => 'Vous devez ajouter au moins un client.',
  'clients:noclientbody' => 'Pour leur envoyer des factures. Voulez-vous en ajouter un maintenant ?',
  'clients:noclienttitlefilter' => 'Aucun client ne correspond à votre filtre.',
  'clients:hasnoinvoicetitle' => 'Ce client est bien configuré!',
  'clients:hasnoinvoicebody' => 'Créons une facture pour obtenir ce qui nous est dû. Voulez-vous en ajouter une maintenant?',
  'clients:added' => 'Le client a été ajouté!',
  'clients:edited' => 'Le client a été mis à jour!',
  'clients:deleted' => 'Le client a été supprimé!',
  'clients:does_not_exist' => 'Ce client n\'existe pas!',
  'clients:health_check' => 'Bilan de santé',
  'clients:all' => 'Tous',
  'clients:delete_title' => 'Supprimer ce client',
  'clients:delete_message' => 'Êtes-vous certain de vouloir supprimer ce client ?<br />Cette action supprimera également toutes les factures, les projets et les devis de ce client.',
  'clients:clientaction' => '&nbsp;',
  'clients:passphrase' => 'Mot de passe',
  'clients:bad_passphrase' => 'Le mot de passe est incorrect.',
  'clients:total_clients' => 'Total de clients',
  'clients:support' => 'Support',
  'clients:support_rates' => 'Tarif du support',
  'clients:edit_support_rates' => 'Appliquer',
  'contact:title' => 'Historique de contact',
  'contact:method' => 'Méthode de contact',
  'contact:contact' => 'Contact',
  'contact:subject' => 'Sujet',
  'contact:content' => 'Contenu',
  'contact:calling_title' => 'Appel du client ":1"',
  'invoices:markassent' => 'Marquer comme envoyé',
  'invoices:invoicedate' => 'Date de facturation',
  'invoices:file_name' => 'Nom du fichier',
  'invoices:date_created' => 'Date de création',
  'invoices:size' => 'Taille',
  'invoices:files' => 'Fichiers',
  'invoices:sentbutunpaid' => 'Factures envoyées mais impayées',
  'invoices:duplicated' => 'Facture dupliquée #:1. Le nuémro de la nouvelle facture est #:2.',
  'invoices:all' => 'Toutes les factures',
  'invoices:empty' => 'Aucune facture',
  'invoices:overdue' => 'Factures dûes',
  'invoices:tax_collected' => 'Taxe perçue',
  'invoices:paid' => 'Factures payées',
  'invoices:recurringinvoices' => 'Factures récurrentes',
  'invoices:unsentinvoices' => 'Factures non envoyées',
  'invoices:unpaid' => 'Factures non payées',
  'invoices:thisinvoicewaspaidon' => 'Cette facture a été payée le :1. Merci!',
  'invoices:senton' => 'Envoyé le :1',
  'invoices:lastsenton' => 'Dernier envoi le :1 à :2',
  'invoices:paidon' => 'Payée le :1',
  'invoices:paidonsingle' => 'Payé le',
  'invoices:thisinvoiceisunpaid' => 'Cette facture n\'a pas encore été payée',
  'invoices:noinvoicetitle' => 'Vous n\'avez aucune facture pour l\'instant',
  'invoices:noinvoicesforthefilteredclient' => 'Vous n\'avez pas de factures pour :1.',
  'invoices:noinvoicebody' => 'Vous devriez créer une facture pour un client dès maintenant! <br /> Les clients adorent les factures!',
  'invoices:send_now_title' => 'Envoyer la facture maintenant?',
  'invoices:send_now_body' => 'Remplissez le formulaire ci-dessous et nous enverrons cette facture pour vous.',
  'invoices:newinvoice' => 'Créer une facture',
  'invoices:timequantity' => 'Qté/Hres',
  'invoices:ratewithcurrency' => 'Tarif (:1)',
  'invoices:taxable' => 'Taxable',
  'invoices:total' => 'Total',
  'invoices:amount' => 'Montant',
  'invoices:due' => 'Dû pour le ',
  'invoices:subtotal' => 'Sous-total',
  'invoices:totaltax' => 'Taxes',
  'invoices:filestodownload' => 'Fichiers à télécharger',
  'invoices:added' => 'La facture a été ajoutée!',
  'invoices:fileswillbeavailableafterpay' => 'Ces fichiers seront disponibles au téléchargement seulement lorsque la facture sera complètement payée.',
  'invoices:no_payment_gateways_enabled' => 'Aucune passerelle de paiement n\'a été activée ce qui pourrait rendre le paiement difficile... Activez-en une dans les <a href=":1">paramètres</a>',
  'invoices:invoicenumber' => 'Facture #:1',
  'invoices:number' => 'Facture #',
  'invoices:type' => 'Type de facture',
  'invoices:is_recurring' => 'Récurrente?',
  'invoices:is_paid' => 'Payé?',
  'invoices:is_sent' => 'Envoyée?',
  'invoices:date_entered' => 'Date de création',
  'invoices:delete_title' => 'Supprimer cette facture?',
  'items:select_time_entry' => 'Entrée de temps',
  'invoices:delete_message' => 'Êtes-vous certain de vouloir supprimer cette facture?',
  'invoices:create' => 'Créer une facture',
  'invoices:edit' => 'Modifier la facture',
  'invoices:amountrequired' => 'Le champ du montant est requis',
  'invoices:currencydoesnotexist' => 'Cette devise n\'existe pas',
  'invoices:unique_id' => 'ID unique',
  'invoices:willbesentautomatically' => 'Le client sera alerté par courriel à propos de cette facture le :1.',
  'invoices:thisisareoccurrence' => 'Cette facture est une récurrence de la facture :1.',
  'invoices:clientlastnotifiedon' => 'Le client a été alerté par courriel à propos de cette facture le :1.',
  'invoices:simple' => 'Simple',
  'invoices:simple_help' => 'Une facture simple n\'a aucun élément, seulement un total.',
  'invoices:detailed' => 'Détaillée',
  'invoices:detailed_help' => 'Une facture détaillée vous permet d\'avoir plusieurs éléments facturables.',
  'invoices:estimate_help' => 'Une estimation est comme une facture détaillée (avec plusieurs éléments), mais n\'est pas facturable.',
  'invoices:unpaid_totalamount' => 'Impayé / Montant total',
  'invoices:saveinvoice' => 'Enregistrer la facture',
  'invoices:deleted' => 'La facture a été supprimée!',
  'invoices:view' => 'Afficher la facture',
  'invoices:is_viewable' => 'Afficher dans l\'espace client?',
  'invoices:no_invoices' => 'Il n\'y a aucune facture',
  'invoices:addedsuccess' => 'Vous avez ajouté une facture pour',
  'invoices:invoice' => 'facture',
  'invoices:addedconf' => 'Vous avez créé la facture # <strong>:1</strong>, d\'un montant total de <strong>:2</strong> (:3 avec taxes) pour :4:5.',
  'invoices:preview' => 'Prévisualiser la facture',
  'invoices:editinvoice' => 'Modifier la facture #:1',
  'invoices:messageupdated' => 'La facture a été mise à jour!',
  'invoices:resend' => 'Réexpédier la facture',
  'invoices:client_viewed' => ':1 a vu la <a href=":2">facture #:3</a> le :4',
  'invoices:client_paid' => ':1 a payé la <a href=":2">facture #:3</a> le :4',
  'invoice:paid_amount' => 'Payé',
  'estimates:attachedtoproposal' => 'Attaché à la proposition #:1',
  'estimates:duplicated' => 'Soumisison dupliquée #:1. Le numéro de le nouveau devis est #:2.',
  'estimates:alltitle' => 'Tous les devis',
  'estimates:attachingtoproposal' => 'Attachement du devis à la proposition... Veuillez patienter.',
  'estimates:delete_title' => 'Supprimer ce devis ?',
  'estimates:delete_message' => 'Désirez-vous vraiment supprimer ce devis ?',
  'estimates:createnew' => 'Créer un devis',
  'estimates:generate_estimate' => 'Générer un devis',
  'estimates:converted' => 'Le devis #:1 a été convertie en projet.',
  'estimates:converted_to_invoice' => 'Le devis #:1 a été convertie en facture.',
  'estimates:noestimatetitle' => 'Vous n\'avez aucun devis.',
  'estimates:noestimatesforthisclient' => 'Vous n\'avez aucun devis pour ce client.',
  'estimates:noestimatesforthefilteredclient' => 'Vous n\'avez pas de devis pour :1.',
  'estimates:deleted' => 'Le devis a été supprimé',
  'estimates:noestimatebody' => 'Vous devriez vous y mettre! Voulez-vous créer un devis maintenant?',
  'estimates:estimatenumber' => 'Devis #:1',
  'estimates:view' => 'Voir le devis',
  'estimates:no_estimates' => 'Il n\'y a aucune soumisison',
  'estimates:addedsuccess' => 'Vous avez ajouté un devis pour',
  'estimates:estimate' => 'devis',
  'estimates:added' => 'Le devis a bien été ajouté.',
  'estimates:addedconf' => 'Vous avez créé le devis # <strong>:1</strong>, d\'un montant total de <strong>:2</strong> (:3 avec taxes) for :4:5.',
  'estimates:send_now_title' => 'Envoyer le devis maintenant?',
  'estimates:send_now_body' => 'Remplissez le formulaire ci-dessous et nous enverrons ce devis pour vous.',
  'estimates:send_now' => 'Envoyer le devis',
  'estimates:edit' => 'Modifier le devis',
  'estimates:preview' => 'Prévisualiser le devis',
  'estimates:editestimate' => 'Modifier le devis #:1',
  'estimates:messageupdated' => 'Le devis a été mise à jour',
  'estimates:client_viewed' => ':1 a vu <a href=":2">le devis #:3</a> le :4',
  'estimates:client_accepted' => ':1 a accepté <a href=":2">le devis #:3</a> le :4',
  'estimates:client_rejected' => ':1 a refusé <a href=":2">le devis #:3</a> le :4',
  'estimates:resend' => 'Renvoyer le devis',
  'estimates:estimatedate' => 'Date du devis',
  'projects:status_id' => 'Statut de la tâche',
  'projects:projected' => 'Prévu',
  'projects:projected_hours' => 'Heures prévues',
  'projects:navigationitem' => 'Projets',
  'projects:hours_worked' => 'Nombres d\'heures travaillées',
  'projects:hours_worked_short' => 'Heures de travail',
  'projects:alltitle' => 'Tous les projets',
  'projects:totalprojects' => 'Total de projets',
  'projects:noprojecttitle' => 'Il n\'y a pas encore de projet!',
  'projects:noprojecttext' => 'Voulez-vous en ajouter un maintenant?',
  'projects:add' => 'Créer un projet',
  'projects:createfromtemplate' => 'Créer à partir d\'un modèle',
  'projects:doesnotexist' => 'Le projet auquel vous tentez d\'accéder n\'existe pas',
  'projects:edit' => 'Modifier le projet',
  'projects:delete' => 'Supprimer le projet',
  'projects:project' => 'Projet',
  'projects:new_project_from_estimate_without_number' => 'Nouveau projet basé sur le devis',
  'projects:new_project_from_estimate_with_number' => 'Nouveau projet basé sur le devis #:1',
  'projects:due_date' => 'Date d\'échéance',
  'projects:is_completed' => 'Complet',
  'projects:manage_project' => 'Gérer le projet',
  'projects:areyousuredeletetask' => 'Êtes-vous certain de vouloir supprimer cette tâche?',
  'projects:add_time' => 'Saisir du temps',
  'projects:add_hours' => 'Ajouter les heures',
  'projects:generate_invoice' => 'Générer la facture',
  'projects:no_projects' => 'Il n\'y a aucun projet',
  'projects:archive_proj' => 'Archiver le projet',
  'projects:archive' => 'Voir l\'archive',
  'projects:active' => 'Projets actifs',
  'projects:archived' => 'Projets archivés',
  'projects:noarchivedprojecttitle' => 'Vous n\'avez aucun projet archivé',
  'projects:noarchivedprojecttext' => 'Vous pouvez archiver un projet à partir de la page du projet concerné.',
  'projects:allarchivedtitle' => 'Tous les projets archivés',
  'projects:templatize' => 'Sauvegarder le modèle',
  'projects:milestone_identifier' => '[Etape: :1]',
  'milestones:add' => 'Ajouter une étape',
  'milestones:edit' => 'Modifier une étape',
  'milestones:delete' => 'Supprimer l\'étape',
  'milestones:milestone' => 'Étape',
  'milestones:target_date' => 'Date cible',
  'milestones:assigned_user' => 'Utilisateur assigné',
  'milestones:select_default' => '-- Aucune étape --',
  'milestones:no_milestone' => 'Tâches sans étape',
  'milestones:add_success' => 'L\'étape ":1" a été ajoutée avec succès',
  'milestones:edit_success' => 'L\'étape ":1" a été modifiée avec succès',
  'milestones:add_failed' => 'L\'étape ":1" n\'a pas pu être modifiée',
  'milestones:edit_failed' => 'L\'étape ":1" n\'a pas pu être ajoutée.',
  'milestones:are_you_sure_delete' => 'Êtes-vous certain de vouloir supprimer cette étape?',
  'milestones:delete_success' => 'L\'étape ":1" a été supprimée avec succès!',
  'milestones:does_not_exist' => 'Cette étape n\'existe pas',
  'milestones:select_assignee_default' => 'N\'assigner personne',
  'reminders:reminders' => 'Rappels',
  'reminders:send' => 'Envoyer les rappels',
  'reminders:success' => 'Ces rappels ont été envoyés!',
  'reminders:remind' => 'Rappeler',
  'reminders:message' => 'Message',
  'reminders:due' => 'Jours',
  'reminders:details' => 'Détails',
  'reminders:log' => 'Historique',
  'emailtemplates:email_templates' => 'Modèle de courriel',
  'emailtemplates:create_template' => 'Créer',
  'emailtemplates:add' => 'Créer un nouveau modèle de courriel',
  'emailtemplates:edit' => 'Modifier le modèle de courriel',
  'emailtemplates:manage' => 'Gérer les modèles',
  'emailtemplates:name' => 'Nom',
  'emailtemplates:subject' => 'Sujet',
  'emailtemplates:days' => 'Nombre de jours',
  'emailtemplates:type' => 'Type de modèle',
  'emailtemplates:success' => 'Le modèle de courriel a été créé avec succès.',
  'emailtemplates:edited' => 'Le modèle de courriel a été modifié avec succès.',
  'emailtemplates:does_not_exist' => 'Le modèle de courriel n\'existe pas.',
  'emailtemplates:deleted' => 'Le modèle de courriel a été bien été supprimé.',
  'emailtemplates:delete_title' => 'Supprimer le modèle de courriel.',
  'emailtemplates:delete_message' => 'Êtes-vous certain de vouloir supprimer ce modèle de courriel?',
  'reports:perclient' => 'par client',
  'reports:datefrom' => 'De',
  'reports:allclients' => 'Tous les clients',
  'reports:dateto' => 'À',
  'reports:byclient' => 'Client',
  'reports:view' => 'Voir le rapport',
  'reports:show_all' => 'Afficher les rapports',
  'reports:paid_and_unpaid' => 'payées et impayées',
  'reports:paid_vs_unpaid_over_time' => 'payées vs. impayées selon la date',
  'reports:per_client' => 'par client',
  'reports:total_with_tax' => 'Total avec taxes',
  'reports:total_without_tax' => 'Total sans taxes',
  'reports:total_collected' => 'Total recueillis',
  'reports:fees_paid' => 'Frais payés',
  'reports:total_amount' => 'Montant total',
  'reports:paid_amount' => 'Montant payé',
  'reports:unpaid_amount' => 'Montant impayé',
  'reports:client_name' => 'Nom du client',
  'reports:nodata' => 'No :1.',
  'currencies:default' => '[Défaut] :1',
  'currencies:cad' => 'Dollar canadien',
  'currencies:eur' => 'Euro',
  'currencies:usd' => 'Dollar U.S.',
  'currencies:gbp' => 'Livre Sterling',
  'currencies:hkd' => 'Dollar de Hong Kong',
  'currencies:php' => 'Perso Philippin',
  'currencies:zar' => 'Rand (Afrique du Sud)',
  'proposals:duplicated' => 'Proposition dupliquée #:1. Le numéro de la nouvelle proposition est #:2.',
  'proposals:usesectiontemplate' => 'Utiliser ce modèle de section',
  'proposals:showcontents' => 'Voir le contenu',
  'proposals:hidecontents' => 'Cacher le contenu',
  'proposals:deletepremadesection' => 'Supprimer ce modèle de section',
  'proposals:nopremadesections' => 'Vous n\'avez sauvegardé aucun modèle de section',
  'proposals:newproposal' => 'Nouvelle proposition',
  'proposals:number' => 'Proposition #',
  'proposals:all' => 'Toutes les propositions',
  'proposals:noproposaltitle' => 'Il n\'y a aucune proposition!',
  'proposals:noproposalbody' => 'Vous devriez créer une proposition. Maintenant. Oui oui!',
  'proposals:client_viewed' => ':1 a vu <a href=":2">la proposition #:3</a> le :4',
  'proposals:client_accepted' => ':1 a accepté <a href=":2">la proposition #:3</a> le :4',
  'proposals:client_rejected' => ':1 a refusé <a href=":2">la proposition #:3</a> le :4',
  'proposals:rejected' => 'Refusé le :1',
  'proposals:accepted' => 'Accepté le :1',
  'proposals:lastviewed' => 'Vu la dernière fois par le client le :1, à :2.',
  'proposals:neverviewed' => 'non vu par le client.',
  'proposals:noanswer' => 'Aucune réponse',
  'proposals:createproposal' => 'Créer une proposition',
  'proposals:editproposal' => 'Modifier la proposition',
  'proposals:createdsuccessfully' => 'Proposition créée avec succès!',
  'proposals:sections' => 'Sections',
  'proposals:section' => 'Section',
  'proposals:createsection' => 'Ajouter une nouvelle section',
  'proposals:createpage' => 'Ajouter une page',
  'proposals:emptysection' => '(aucun titre)',
  'proposals:emptycontents' => '(aucun contenu)',
  'proposals:emptysubtitle' => '(aucun sous-titre)',
  'proposals:for' => 'Proposition pour : ',
  'proposals:pagexofcount' => 'Page :1 de :2',
  'proposals:saving' => 'Sauvegarde en cours ...',
  'proposals:save' => 'Sauvegarder la proposition',
  'proposals:savepremade' => 'Sauvegarder comme modèle de section',
  'proposals:addestimate' => 'Ajouter un devis',
  'proposals:saved' => 'Sauvegardé',
  'proposals:createandedit' => 'Suivant : modifier le contenu de la proposition',
  'proposals:delete_message' => 'Êtes-vous certain de vouloir supprimer cette proposition?',
  'proposals:createpremadesection' => 'Ajouter à partir du modèle de section',
  'proposals:selected_attachments' => 'Sélectionner le devis',
  'proposals:attach_selected_estimate' => 'Joindre le devis sélectionné',
  'proposals:proposal' => 'Proposition',
  'proposals:status' => 'Statut',
  'proposals:view' => 'Voir la proposition',
  'proposals:estimate' => 'Devis',
  'proposals:no_proposals' => 'Il n\'y a aucune proposition',
  'proposals:proposal_title' => 'Titre du devis',
  'proposals:kitchennotice' => 'Note : Les propositions apparaîtront dans le :1 une fois que le client aura visionné le lien de la proposition. Autrement dit, vous pouvez modifier tout ce que vous voulez et le client ne verra ces modifications que lorsque vous le voudrez.',
  'proposal:outline' => 'Plan de proposition',
  'tasks:task' => 'Tâche',
  'tasks:edit_succeeded' => 'Tâche modifiée avec succès',
  'tasks:hours' => 'Heures',
  'tasks:due_date' => 'Date d\'échéance',
  'tasks:is_completed' => 'Complété?',
  'tasks:timer' => 'Chronomètre',
  'tasks:rate' => 'Tarif',
  'tasks:default_rate' => 'Tarif par défaut',
  'tasks:entries' => 'Saisies de temps',
  'tasks:view_entries' => 'Voir les saisies',
  'tasks:edit_entry' => 'Modifier la saisie',
  'tasks:create' => 'Ajouter une tâche',
  'tasks:create_sub' => 'Ajouter une sous-tâche',
  'tasks:task_parent' => 'Tâche parente',
  'tasks:edit' => 'Modifier la tâche',
  'tasks:create_succeeded' => 'La tâche a été créée',
  'tasks:no_task_title' => 'Il n\'y a pas encore de tâche',
  'tasks:no_task' => 'Pas de tâche',
  'tasks:no_task_message' => 'Vous devriez en créer une tâche',
  'tasks:is_viewable' => 'Visible dans l\'espace client',
  'tasks:no_milestones' => 'Tâches sans étape.',
  'tasks:not_related_to_a_task' => '-- Associé à aucune tâche --',
  'tasks:select_parent_default' => '-- Aucune tâche parente --',
  'tasks:timers_running' => 'Chronomètre(s)',
  'tasks:task_completed_by' => ':1 a complété la <a href=":2">tâche :3</a> le :4',
  'tasks:discussion' => 'Discussion : ',
  'tasks:billed_hours' => 'Heures facturées',
  'tasks:unbilled_hours' => 'Heures non-facturées',
  'users:create_user' => 'Créer un utilisateur',
  'users:confirm_delete_emphasised' => 'Cette action est définitive!',
  'items:name' => 'Nom de l\'élément',
  'items:description' => 'Description de l\'élément',
  'items:qty_hrs' => 'Qté / Hres',
  'items:quantity' => 'Quantité',
  'items:rate' => 'Tarif',
  'items:tax_rate' => 'Total des taxes',
  'items:cost' => 'Coût',
  'items:line_items' => 'Élément',
  'items:add' => 'Ajouter un élément',
  'items:edit' => 'Modifier l\'élément',
  'items:noitemtitle' => 'Vous n\'avez pas encore d\'élément!',
  'items:noitembody' => 'Vous devriez ajouter des éléments maintennat, ça rend la création de facture vraiment facile!',
  'items:delete_title' => 'Supprimer cet élément?',
  'items:delete_message' => 'Êtes-vous certain de vouloir supprimer l\'élément ":1"?',
  'items:type' => 'Type',
  'items:select_standard' => 'Standard',
  'items:select_expense' => 'Dépense',
  'items:add_expense_to_project' => 'Ajouter une dépense',
  'items:expenses' => 'Dépenses',
  'expenses:expenses' => 'Dépenses',
  'expenses:add' => 'Ajouter une dépense',
  'expenses:edit_expense' => 'Modifier',
  'expenses:delete' => 'Supprimer la dépense',
  'expenses:deleted' => 'Dépense supprimée',
  'expenses:all' => 'Toutes les dépenses',
  'expenses:amount' => 'Montant',
  'expenses:supplier' => 'Fournisseur',
  'expenses:suppliers' => 'Fournisseurs',
  'expenses:category' => 'Catégorie',
  'expenses:categories' => 'Catégories',
  'expenses:add_supplier' => 'Ajouter',
  'expenses:edit_supplier' => 'Modifier',
  'expenses:add_category' => 'Ajouter',
  'expenses:edit_category' => 'Modifier',
  'expenses:parent_category' => 'Catégorie parente',
  'expenses:filter' => 'Filtrer les dépenses',
  'expenses:start_date' => 'Date de début',
  'expenses:end_date' => 'Date de fin',
  'transactions:paymentcancelled' => 'Paiement annulé',
  'transactions:extrapaymentcancelled' => 'Votre paiement a été annulé',
  'transactions:paymentreceived' => 'Paiement reçu',
  'transactions:fee_applied' => 'Comme :1 impose ses propres frais de transaction, nous avons ajouté :2% au montant.',
  'transactions:orderbeingprocessed' => 'Veuillez patienter, votre commande est en cours de traitement et vous serez redigiré vers le site :1 sous peu.',
  'transactions:ifyouarenotredirected' => 'Si vous n\'êtes pas redirigé automatiquement vers :1 dans 5 secondes...',
  'transactions:thankyouforyourpayment' => 'Merci pour votre paiement. Vous devriez recevoir le reçu par courriel sous peu.',
  'transactions:ifyouhavefilesyouwillgetanemail' => 'Si vous attendez la livraison de fichiers, vous recevrez un courriel contenant un lien pour les télécharger sous peu.',
  'transactions:ifyoudonotreceiveemail' => 'Si vous ne recevez pas de courriel d\'ici une heure, veuillez contacter :1',
  'timesheet:taskname' => 'Nom de la tâche',
  'timesheet:starttime' => 'Départ',
  'timesheet:endtime' => 'Fin',
  'timesheet:timeframe' => 'Délais',
  'timesheet:duration' => 'Durée',
  'timesheet:date' => 'Date',
  'timesheet:forproject' => 'Feuille de temps pour le projet ":1"',
  'timesheet:timesheet' => 'Feuille de temps',
  'timesheet:for' => 'Feuille de temps pour : ',
  'timesheet:totalbillable' => 'Total d\'heures facturables',
  'timesheet:view_pdf' => 'Voir la feuille de temps',
  'timesheet:user' => 'Utilisateur',
  'timesheet:entries' => 'Saisies',
  'timesheet:no_entries' => 'Il n\'y a aucune saisie de temps',
  'tickets:all_tickets' => 'Tous les billets',
  'tickets:support_tickets' => 'Billets de support',
  'tickets:pending' => 'En attente',
  'tickets:open' => 'Ouvert',
  'tickets:resolved' => 'Résolu',
  'tickets:closed' => 'Fermé',
  'tickets:respond' => 'Répondre au billet',
  'tickets:ticket_options' => 'Options du billet',
  'tickets:attachment' => 'Pièces jointes',
  'tickets:updated_status' => ':1 a mis à jour le status du billet pour :2',
  'tickets:add_a_new_ticket' => 'Ajouter un nouveau billet',
  'tickets:create_a_new_ticket' => 'Créer un nouveau billet',
  'tickets:add_ticket' => 'Ajouter un billet',
  'tickets:assign_to_user' => 'Assigner à l\'utilisateur',
  'tickets:select_client' => 'Sélectionnez le client',
  'tickets:ticket_subject' => 'Objet du billet',
  'tickets:ticket_message' => 'Message du billet',
  'tickets:ticket_priority' => 'Priorité du billet',
  'tickets:ticket_status' => 'Status du billet',
  'tickets:no_priority' => '-- Aucune priorité --',
  'tickets:no_status' => '-- Aucun statut --',
  'tickets:no_posts' => 'Aucun message.',
  'frontend:hithere' => 'Bonjour !',
  'frontend:followthemaillinkdude' => 'Pour voir votre facture, vous devez cliquer sur le lien entier dans le courriel que vous avez reçu. Le lien ressemble à ceci : :1.',
  'frontend:contactadminforassistance' => 'Pour toute assistance, veuillez contacter :1 @ :2',
  'settings:task_statuses' => 'Statuts des tâches',
  'settings:ticket_statuses' => 'Statuts des billets',
  'settings:ticket_priorities' => 'Priorités des billets',
  'settings:background_color' => 'Couleur de fond',
  'settings:text_color' => 'Couleur du texte',
  'settings:text_shadow' => 'Ombre du texte',
  'settings:box_shadow' => 'Ombre portée',
  'settings:default_rate' => 'Tarif par défaut',
  'settings:allowed_extensions' => 'Permettre le téléversement d\'extension',
  'settings:comma_separated' => 'séparé par des virgules',
  'settings:pdf_page_size' => 'Dimensions de la page des PDF générés',
  'settings:default_invoice_notes' => 'Notes par défaut de la facture',
  'settings:default_invoice_title' => 'Titre par défaut de la facture',
  'settings:default_invoice_due_date' => 'Date d\'échéance par défaut',
  'settings:autosave_proposals' => 'Sauvegarder automatiquement le devis',
  'settings:default_invoice_due_date_explain' => 'jours après la création de la facture. Si vous ne voulez pas de date par défaut, laissez ce champ vide.',
  'settings:testemailsettings' => 'Paramètres de courriels tests',
  'settings:include_remittance_slip' => 'Bordereaux de paiement',
  'settings:include_remittance_slip_explain' => 'Si ce paramètre est sélectionné, le PDF de la facture incluera un bordereau de paiement.',
  'settings:items_per_page' => 'Éléments par page',
  'settings:items_per_page_explain' => 'Nombre d\'éléments (factures/etimés/devis/projets/tâches) à afficher par page.',
  'settings:send_x_days_before' => '"Envoyer x jours d\'avance" par défaut',
  'settings:send_x_days_before_explain' => 'Nombre de jours par défaut avant qu\'une facture soit automatiquement envoyée à un client.',
  'settings:file_to_import' => 'Fichier à importer',
  'settings:file_should_be_csv' => 'Pancake traitera automatiquement votre fichier et importera le tout. Si Pancake est incapable de traiter votre fichier, il vous le laissera savoir et il vous donnera l\'option de nous envoyer quelques informations pour rendre Pancake fonctionnel avec votre fichier.',
  'settings:importnow' => 'Importer maintenant!',
  'settings:whatimporting' => 'Que voulez-vous importer?',
  'settings:whatexporting' => 'Que voulez-vous exporter?',
  'settings:nouploadedimportfile' => 'Vous n\'avez pas téléversé un fichier à importer',
  'settings:import' => 'Importer (bêta)',
 'settings:importedclients' => ':1 client(s) importé(s) avec succès.',
  'settings:importedprojects' => ':1 projet(s) importé(s) avec succès.',
  'settings:importedusers' => ':1 utilisteur(s) importé(s) avec succès.',
  'settings:importedinvoices' => ':1 facture(s) importée(s) avec succès.',
  'settings:importedtasks' => 'Importé :1 tâches avec succès.',
  'settings:importedestimates' => 'Importé :1 estimés avec succès.',
  'settings:importedtime_entries' => 'Importé :1 saisies de temps avec succès.',
  'settings:xwereduplicates' => ':1 étaient des duplicatas et ont été ignorés.',
  'settings:import_desc' => 'Importer des données dans Pancake.',
  'settings:export' => 'Exporter',
  'settings:exportnow' => 'Exporter maintenant!',
  'settings:importexport' => 'Importer / Exporter',
  'settings:removelogo' => 'Retirer le logo',
  'settings:wrong_license_key' => 'La clé de license que vous avez entré n\'est pas valide',
  'settings:noopenssl' => 'Votre serveur PHP n\'a pas de configuration OpenSSL active ce qui veut dire que vous ne pouvez pas utiliser Gmail ou d\'autres applications Google pour envoyer des courriels',
  'settings:logoremoved' => 'Logo retiré avec succès!',
  'settings:save' => 'Sauvegarder',
  'settings:logodimensions' => 'Le logo sera redimensionné automatiquement.',
  'settings:logoformatsallowed' => 'Seulement les fichiers de type BMP, PNG, JPG (JPEG) et GIF sont autorisés',
  'settings:ftp_user' => 'Utilisateur FTP',
  'settings:ftp_pass' => 'Mot de passe FTP',
  'settings:ftp_path' => 'Chemin FTP',
  'settings:ftp_port' => 'Port FTP',
  'settings:ftp_pasv' => 'Mode passif?',
  'settings:nophpupdates' => 'À cause de la façon dont votre serveur est configuré, vous devez entrer vos informations FTP pour que Pancake puisse se mettre à jour. Cet informations ne sont utilisées qu\'à l\'interne de Pancake et ne seront jamais transmises à personne.',
  'settings:ftp_host' => 'Hôte FTP',
  'settings:uptodate' => 'Pancake est bien à jour (:1)',
  'settings:newversionavailable' => 'Une nouvelle version de Pancake est disponible (:1)!',
  'settings:updatenow' => 'Mettre à jour maintenant!',
  'settings:checkforupdates' => 'Vérifier les mises à jour',
  'settings:youneedtoconfigurefirst' => 'Votre Pancake n\'est pas configuré pour se mettre à jour. Veuillez entrer vos informations de connexion FTP ci-dessous et cliquez sur "Sauvegarder les configurations".<br>Pancake vous laissera ensuite le mettre à jour',
  'settings:general' => 'Général',
  'settings:emails' => 'Courriels',
  'settings:taxes' => 'Taxes',
  'settings:currencies' => 'Devises',
  'settings:branding' => 'Image de marque',
  'settings:payment_methods' => 'Paiements',
  'settings:feeds' => 'Flux',
  'settings:api_keys' => 'Clés API',
  'settings:time_entry_times' => 'Entrées de temps',
  'settings:include_dates_and_times_in_line_items' => 'Inclure les dates et les heures dans l\'item entrées de temps.',
  'settings:when_generating_invoice' => 'Lors de la génération des factures , utiliser une ligne par',
  'settings:use_utf8_font' => 'Utilisez des polices UTF-8 dans les fichiers PDF',
  'settings:use_utf8_font_explanation' => 'Utilisez cette option si les caractères sont brisés dans vos fichiers PDF .',
  'settings:pdf_attachments' => 'Pièces jointes PDF',
  'settings:pdf_attachments_explanation' => 'Si elle est cochée , Pancake va fixer le PDF correspondant à la facture , devis ou proposition par emails.',
  'settings:site_name' => 'Nom du site',
  'settings:language' => 'Langue',
  'settings:timezone' => 'Fuseau horaire',
  'settings:notify_email' => 'Courriel de notification',
  'settings:currency' => 'Devise',
  'settings:theme' => 'Thème frontend',
  'settings:admin_theme' => 'Thème de l\'admin',
  'settings:admin_name' => 'Nom de l\'admin',
  'settings:date_format' => 'Format de date',
  'settings:time_format' => 'Format de l\'heure',
  'settings:task_time_interval' => 'Arrondir les saisies de temps (laissez vide pour ne pas arrondir)',
  'settings:task_time_interval_description' => '(ex.: 00:30 ou 0.5 - toutes les saisies de temps seront arrondies à la demi-heure près lors de la génération de facture.)',
  'settings:mailing_address' => 'Adresse postale',
  'settings:default_subject' => 'Sujet par défaut',
  'settings:default_contents' => 'Message par défaut',
  'settings:new_estimate' => 'Nouvel estimé',
  'settings:new_invoice' => 'Nouvelle facture',
  'settings:new_proposal' => 'Nouveau devis',
  'settings:paid_notification' => 'Notification de paiement',
  'settings:payment_receipt' => 'Reçu de paiement',
  'settings:new_ticket' => 'Nouveau billet',
  'settings:ticket_invoice' => 'Nouvelle facture de billet',
  'settings:ticket_updated' => 'Billet mis à jour',
  'settings:ticket_status_updated' => 'Status du billet mis à jour',
  'settings:logo' => 'Votre logo',
  'settings:frontend_css' => 'CSS personnalisé du frontend',
  'settings:backend_css' => 'CSS personnalisé de l\'admin',
  'settings:rss_password' => 'Mot de passe du fil RSS',
  'settings:default_feeds' => 'Flux par défaut',
  'settings:cron_job_feed' => 'Tâche cron',
  'settings:feed_generator' => 'Générateur de flux',
  'settings:your_link' => 'Votre lien',
  'settings:bcc' => 'BCC',
  'settings:automaticallybccclientemail' => 'Envoyer une copie de tous les courriels de vos clients à votre adresse principale.',
  'settings:api_note' => 'Nom / note',
  'settings:api_key' => 'Clé API',
  'settings:tax_name' => 'Nom de taxe',
  'settings:tax_value' => 'Valeur',
  'settings:tax_reg' => 'Numéros de taxes',
  'settings:add_tax' => 'Ajouter une autre taxe',
  'settings:currency_name' => 'Nom de la devise',
  'settings:currency_code' => 'Code de la devise',
  'settings:exchange_rate' => 'Taux de change',
  'settings:add_currency' => 'Ajouter une autre devise',
  'update:ifyourenotsurecontactus' => 'Si vous n\'êtes pas certain de ce que vous faites, veuillez <a href=\'http://pancakeapp.com/forums/newtopic/2/\'>commencer un nouveau ticket de support dans le forum</a>.',
  'update:youmodified' => 'Vous avez modifié',
  'update:youdeleted' => 'Vous avez supprimé',
  'update:loadingpleasewait' => 'Sauvegarde en cours...',
  'update:errordownloading' => 'Une mise à jour de Pancake est disponible, mais des problèmes sont survenus lors du téléchargement.',
  'update:herearestepstofix' => 'Voici quelques étapes que vous pouvez essayer afin de corriger le problème : ',
  'update:makesureuploadsiswritable' => 'Assurez-vous que votre dossier de téléversement est inscriptible (CHMOD 0777).',
  'update:deletepancakesystemupdate' => 'Supprimez le dossier pancake-update-system (à l\'intérieur du dossier de uploads) et tout ce qu\'il contient.',
  'update:loadpancakeagain' => 'Ouvrez Pancake à nouveau. Si l\'erreur persiste, changez le propriétaire du dossier Pancake (CHOWN) pour qu\'il corresponde à l\'utilisateur de votre serveur.',
  'update:whatschanged' => 'Quoi de neuf dans :1',
  'update:ftp_conn' => 'Pancake n\'a pas pu se connecter à l\'hôte FTP',
  'update:ftp_login' => 'Pancake n\'a pas pu se connecter via FTP (mot de passe ou utilisateur FTP erronné)',
  'update:ftp_chdir' => 'Pancake n\'a pas pu configurer le chemin FTP (le chemin vers ce dossier n\'existe probablement pas)',
  'update:ftp_no_uploads' => 'Pancake n\'a pas pu obtenir les permissions nécessaires pour téléverser des fichiers par FTP.',
  'update:ftp_indexwrong' => 'Le chemin FTP que vous avez entré est incorrect. Le chemin devrait être celui du dossier de Pancake.',
  'update:ftp_indexnotfound' => 'Le chemin FTP que vous avez entré est incorrect. Le chemin devrait être celui du dossier de Pancake.',
  'update:update_conflict' => 'Vous avez modifié certains fichiers depuis la dernière mise à jour. Dans le but de sauvegarder vos modifications, voici une liste des fichiers que vous avez modifiés qui entrent en conflit avec la mise à jour la plus récente.',
  'update:update_no_perms' => 'Pancake n\'a pas les permissions suffisantes pour se mettre à jour et il n\'a pas accès à un compte FTP duquel il peut se mettre à jour. La mise à jour ne peut pas continuer',
  'update:review_files' => 'Veuillez réviser ces fichiers et en faire une sauvegarde avant de procéder. Lorsque la mise à jour sera terminée, vous devrez réintégrer vos modifications dans ceux-ci. Veuillez ne pas simplement remplacer le nouveau fichier par l\'ancien puisque certaines fonctionnalités pourraient être écrasées.',
  'update:internetissues' => 'Pancake est incapable de se connecter à Internet.',
  'update:pancakeneedsinternet' => 'Pour que Pancake fonctionne correctement, votre serveur doit lui permettre de requérir certaines informations provenant d\'Internet (port 80)',
  'update:maybefirewall' => 'Il semblerait que votre serveur empêche Pancake d\'accéder à Internet. Il pourrait s\'agir d\'un problème de pare-feu de la part de votre serveur. Veuillez contacter votre hébergeur et demandez-lui de permettre PHP d\'accéder à :1.',
  'update:nointernetaccess' => 'Aucun accès Internet',
  'update:pancakeupdated' => 'Pancake a été mis à jour de :1 à :2',
  'partial:totalamounttobepaid' => 'Montant total devant être payé par le client',
  'partial:amount' => 'Montant',
  'partial:add_payment' => 'Ajouter un paiement',
  'partial:dueon' => 'Dû le',
  'partial:paymentdetails' => 'Détails du paiement',
  'partial:savepaymentdetails' => 'Sauvegarder les détails de paiement',
  'partial:proceedtopayment' => 'Procédez au paiement',
  'partial:topaynowgoto' => 'Pour payer maintenant, veuillez vous rendre au :1',
  'partial:pay_part_x_now' => 'Payez la partie #:1 de votre facture maintenant',
  'partial:dueondate' => 'dû le :1',
  'partial:paymentmethod' => 'Méthode de paiement',
  'partial:paymentdate' => 'Date du paiement',
  'partial:paymentstatus' => 'Status du paiement',
  'partial:transactionid' => 'ID de transaction',
  'partial:markaspaid' => 'Marquer comme payé',
  'partial:transactionfee' => 'Frais de transaction',
  'paypal:clickhere' => 'Cliquez ici pour procéder',
  'authorize:transaction_key' => 'Clé de transaction',
  'paypal:email' => 'Courriel PayPal',
  'paypal:fee' => 'Frais PayPal (%)',
  'paypalpro:paypalpro' => 'Paiement par PayPal Pro (BETA)',
  'paypalpro:viacreditcard' => 'Payer par carte de crédit',
  'cash:cash' => 'Argent',
  'check:check' => 'Chèque',
  'moneyorder:moneyorder' => 'Mandat-poste',
  'creditcard:creditcard' => 'Carte de crédit',
  'banktransfer:banktransfer' => 'Transfert bancaire',
  'gateways:errorupdating' => 'Une erreur s\'est produite lors de la mise à jour de vos paramètres de paiement. Veuillez contacter le support.',
  'gateways:paymentmethods' => 'Méthodes de paiement',
  'gateways:selectpaymentmethod' => 'Sélectionnez une méthode de paiement',
  'gateways:nogatewayused' => 'Aucune méthode de paiement n\'a été utilisée. Une partie reste impayée.',
  'gateways:completed' => 'Complété',
  'gateways:refunded' => 'Remboursé',
  'gateways:unpaid' => 'Impayé',
  'gateways:paymentrejected' => ':1 Paiement rejeté',
  'gateways:pending' => 'En cours',
  'gateways:returntowebsite' => 'Retourner à :1',
  'gateways:cc_type' => 'Type de carte de crédit',
  'gateways:cc_number' => 'Numéro de carte de crédit',
  'gateways:cc_exp' => 'Date d\'expiration',
  'gateways:cc_cardholder' => 'Nom du détenteur de la carte',
  'gateways:cc_code' => 'Code de sécurité',
  'gateways:payment_details' => 'Détails de paiement',
  'gateways:api_signature' => 'Signature de l\'API',
  'gateways:api_password' => 'Mot de passe de l\'API',
  'gateways:api_username' => 'Nom d\'utilisateur de l\'API',
  'kitchen:edit_comment' => 'Modifier le commentaire',
  'kitchen:add_a_comment' => 'Ajouter un commentaire',
  'kitchen:kitchen_name' => 'Espace client',
  'kitchen:pleaselogin' => 'Veuillez entrer votre mot de passe pour accéder à votre compte',
  'kitchen:nocomments' => 'Aucun commentaire',
  'kitchen:comment' => 'Commentaire',
  'kitchen:comments' => 'Commentaires',
  'kitchen:comments_x' => 'Commentaires (:1)',
  'kitchen:file' => 'Fichier',
  'kitchen:submitcomment' => 'Ajouter un commentaire',
  'kitchen:attachment' => 'Pièce jointe',
  'kitchen:saidon' => 'a dit le :1, à :2',
  'kitchen:subjectinvoice' => 'Nouveau commentaire pour la facture #',
  'kitchen:subjectestimate' => 'Nouveau commentaire pour l\'estimé #',
  'kitchen:subjectproject' => 'Nouveau commentaire pour le projet : ',
  'kitchen:subjecttask' => 'Nouveau commentaire pour la tâche : ',
  'kitchen:subjectproposal' => 'Nouveau commentaire pour le devis : ',
  'kitchen:backtodashboard' => 'Retourner au panneau de contrôle',
  'kitchen:client_welcome' => 'Espace client pour : ',
  'kitchen:urltosend' => 'URL de l\'espace client',
  'kitchen:nopassphrase' => 'Présentement, le mot de passe client n\'est pas configuré, ce qui veut dire qu\'accéder à cet URL est tout ce qu\'il faut faire pour voir l\'accès client. Si vous voulez sécuriser l\'accès et ajouter un mot de passe, éditez ce client pour ce faire.',
  'kitchen:passphraseset' => 'Ce client a un mot de passe déjà configuré',
  'kitchen:passphrase' => 'Mot de passe',
  'kitchen:description' => 'Ceci est l\'URL à envoyer à votre client pour lui permettre d\'accéder à l\'espace client où il peut voir ses éléments (projets, facutres) que vous avez rendus visibles de son côté.',
  'kitchen:people_in_discussion' => 'Personnes dans la conversation',
  'kitchen:latest_invoice' => 'Dernière facture',
  'kitchen:unpaid_balance' => 'Solde impayé: :1',
  'kitchen:total_paid_to_date' => 'Total payé à ce jour: :1',
  'store:store' => 'Magasin',
  'store:buy' => 'Acheter ($:1)',
  'store:update' => 'Mettre à jour',
  'store:install' => 'Installer',
  'store:settings' => 'Paramètres',
  'store:already_bought' => 'Vous avez déjà acheté cet article!',
  'store:installed_successfully' => 'Vous avez installé le :1 :2 avec succès.',
  'store:plugin' => 'Plugiciel',
  'store:payment_gateway' => 'Passerelle de paiement',
  'store:frontend_theme' => 'Thème accès client',
  'store:backend_theme' => 'Thème d\'administration',
  'store:unknown' => 'Inconnu',
  'store:updatestoreitems' => 'Mise à jour des articles du magasin',
  'store:download_free' => 'Télécharger gratuitement',
  'store:error1000' => 'Votre jeton d\'autorisation n\'est plus valide. Vous devrez entrer vos informations de paiement dans pancakeapp.com une fois de plus.',
  'store:error1001' => 'Vous avez déjà acheté cet article de magasin!',
  'store:error1002' => 'Un problème est survenu lors de la tentative de débiter votre carte de crédit. Réessayez plus tard.',
  'store:error1003' => 'Vous avez fait une demande non valide.',
  'email_templates:new_invoice' => 'Nouvelle facture',
  'email_templates:new_estimate' => 'Nouveau devis',
  'email_templates:new_proposal' => 'Nouvelle proposition',
  'email_templates:invoice_payment_notification_for_admin' => 'Avis de paiement (envoyé à l\'admin)',
  'email_templates:invoice_payment_notification_for_client' => 'Notification de réception de paiement (envoyé au client)',
  'email_templates:new_ticket' => 'Nouveau billet',
  'email_templates:new_ticket_invoice' => 'Nouvelle facture de billet',
  'email_templates:ticket_updated' => 'Notification de mise à jour d\'un billet',
  'email_templates:ticket_status_updated' => 'Notification de mise à jour du statut d\'un billet',
  'email_templates:assigned_to_task' => 'Notification d\'affectation des tâches',
  'email_templates:assigned_to_milestone' => 'Notification d\'affectation d\'une étape',
  'email_templates:new_comment' => 'Notification de nouveau commentaire',
  'global:timer_app' => 'Minuteur Pancake',
  'global:there_is_no_activity' => 'Il n\'y a pas d\'activité d\'équipe à afficher.',
  'global:there_are_no_tasks_assigned_to_you' => 'Vous n\'avez pas de tâches assignées.',
  'invoices:converted_to_estimate' => 'Facture #:1 converti en devis.',
  'global:converttoestimate' => 'Convertir en devis',
  'tickets:view_archived' => 'Voir les billets archivés',
  'tickets:view_unarchived' => 'Voir les billets actifs',
  'tickets:archiving_ticket' => 'Archiver le billet',
  'tickets:unarchiving_ticket' => 'Désarchiver le billet',
  'tickets:unknown_error_ticket_not_altered' => 'Une erreur inconnue s\'est produite. Votre ticket n\'a pas été modifiée.',
  'tasks:starting_timer' => 'Lancer le minuteur',
  'tasks:stopping_timer' => 'Arrêter le minuteur',
  'global:all_comments' => 'Tous les commentaires',
  'dashboard:view_all_comments' => 'Voir tous les commentaires',
  'dashboard:latest_comments' => 'Derniers commentaires',
  'dashboard:written_by' => 'Écrit par :1 le :2',
  'dashboard:client_activity' => 'Activités des clients',
  'dashboard:view_all_client_activity' => 'Voir toutes les activités des clients',
  'dashboard:team_activity' => 'Activité',
  'dashboard:view_all_team_activity' => 'Voir toutes les activités de l\'équipe',
  'dashboard:my_tasks' => 'Mes tâches',
  'dashboard:view_all_my_tasks' => 'Voir tous mes tâches',
  'dashboard:what_the_team_is_working_on' => 'Sur quoi travaille l\'équipe.',
  'global:save_milestone' => 'Enregistrer l\'étape',
  'global:save_task' => 'Enregistrer la tâche',
  'global:private_comment' => 'Ce commentaire est privé. Votre client ne le verra pas.',
  'global:clients_cant_see_private' => 'Les clients ne peuvent pas voir les commentaires privés.',
  'global:is_private' => 'Privé?',
  'tickets:disable_client' => '-- Désactiver les billets de support --',
  'global:css' => 'CSS personnalisé',
  'global:js' => 'JavaScript personnalisé',
  'global:js_explanation' => 'Vous pouvez utiliser jQuery à volonté. Votre code sera ajouté juste avant &lt;/body&gt;.',
  'settings:frontend_js' => 'Javascript personnalisé frontend',
  'settings:backend_js' => 'Javascript personnalisé backend',
  'proposals:estimate_number_and_amount' => 'Devis #:1 (:2)',
  'clients:delete' => 'Supprimer le client',
  'global:nolongerexists' => '[N\'EXISTE PLUS]',
  'global:billed_amount' => 'Montant facturé',
  'global:unbilled_amount' => 'Montant non facturés',
  'global:is_billed' => 'Facturé',
  'settings:year_start' => 'Date de début de l\'année fiscale',
  'dashboard:since_explanation' => 'Depuis :1',
  'export:invoices_csv' => 'Factures (CSV)',
  'projects:createdtemplate' => 'Modèle de projet créé. Vous pouvez créer des projets basé sur ce modèle.',
  'projects:delete_template' => 'Supprimer le modèle',
  'projects:deleted_template' => 'Modèle supprimé avec succès.',
  'export:expenses_csv' => 'Dépenses (CSV)',
  'export:clients_csv' => 'Clients (CSV)',
  'projects:expense_date' => 'Date de dépenses',
  'clients:can_create_support_tickets' => 'Permettre au client de créer un billet de support',
  'tickets:submit_new' => 'Créer un billet',
  'global:cancel' => 'Annuler',
  'global:timers' => 'Minuteurs',
  'global:more' => 'Plus',
  'global:search' => 'Rechercher',
  'authorize:api_login_id' => 'Identifiants pour l\'API',
  'authorize:api_login_id_description' => 'Vous trouverez ceci dans Authorize.net sous Compte > Identifiants API et clé de transaction.',
  'authorize:md5_hash' => 'MD5-Hash',
  'authorize:md5_hash_description' => 'Voici votre identifiant pour l\'API par défaut. Vous pouvez le changer dans Authorize.net, sous Compte > MD5-Hash. Si vous voyez \'Hash Value Set: No\', laissez le vide.',
  'transactions:paymentfailed' => 'Erreur lors du paiement',
  'transactions:extrapaymentfailed' => 'Un problème est survenu lors du traitement de votre paiement. Veuillez contacter :1 at :2 pour obtenir de l\'aide.',
  'projects:tracked' => 'Suivi',
  'invoices:partially_paid' => 'Partiellement',
  'global:projects_ommitted' => ':1 projets non représentés',
  'global:tasks_ommitted' => ':1 tâches non représentés',
  'login:username_email' => 'Utilisateur / Courriel',
  'global:update_available' => ':1 mise à jour disponible',
  'settings:when_new_updates_are_available' => 'Lorsque les mises à jour sont disponibles',
  'settings:dont_install_just_notify_me' => 'Informez-moi des mises à jour',
  'settings:install_automatically' => 'Installer les mises à jour automatiquement',
  'settings:loading_update_details' => 'Téléchargement des informations de mises à jour...',
  'settings:updating_please_wait' => 'Mise à jour en cours, veuillez patienter. Cette page sera actualisée une fois la mise à jour terminée.',
  'settings:will_have_to_overwrite_single_file' => 'Pancake devra écraser 1 fichier que vous avez modifié manuellement.',
  'settings:will_have_to_overwrite_multiple_files' => 'Pancake devra écraser :1 fichier que vous avez modifié manuellement.',
  'settings:checking_for_updates' => 'Recherche des mises à jour, veuillez patienter.. Cette page sera actualisé.',
  'settings:description' => 'Enregistrez vos nouveaux paramètres avant de changer de champ ou de page.',
  'settings:business_identities' => 'Identités d\'affaires',
  'settings:business_name' => 'Nom d\'entreprise',
  'settings:new_business' => 'Nouvelle entreprise',
  'settings:business_identity' => 'Identité d\'affaire',
  'settings:business_identity_explanation' => 'L\'identité d\'affaire de votre client sera affiché sur chacun des courriels, PDF et des pages.',
  'settings:have_been_updated' => 'Les paramètres ont été mis à jour.',
  'tasks:all' => 'Toutes les tâches',
  'projects:progress' => 'Progrès',
  'expenses:name' => 'Nom de la dépense',
  'tasks:add_hours_to' => 'Ajouter les heures à :1',
  'global:today' => 'Aujourd\'hui',
  'global:yesterday' => 'Hier',
  'global:other' => 'Autre',
  'global:now' => 'Maintenant',
  'timesheet:view_for_clients' => 'Voir la feuille de temps (pour les clients)',
  'global:not_billed_yet' => 'Non facturé',
  'tasks:total_logged_time' => 'Temps total enregistré',
  'global:biweekly' => 'Bi-hebdomadaire',
  'settings:default_task_due_date' => 'Tâches dues par défaut',
  'settings:default_task_due_date_explain' => 'jours après que la tâche est créé. Si vous ne voulez pas une date par défaut, laissez vide.',
  'expenses:sort_or_filter' => 'Classer/Filtrer les dépenses',
  'expenses:show' => 'Montrer les dépenses',
  'global:sort_by' => 'Classer par',
  'global:sort_order' => 'Classer les commandes',
  'global:asc' => 'Ascendant (A-Z)',
  'global:desc' => 'Descendant (Z-A)',
  'settings:tax_compound' => 'Taxe combinée',
  'settings:no_tax' => 'Aucune taxe',
  'settings:default_taxes' => 'Taxes par défaut',
  'global:and' => 'et',
  'global:tax' => 'Taxe(s)',
  'global:updates_available' => ':1 mises à jour disponible',
  'global:youarenotallowed' => 'Vous n\'avez pas les droit nécessaire pour accéder à cette page.',
  'dashboard:today' => 'Aujourd\'hui',
  'dashboard:your_projects' => 'Projets',
  'dashboard:snapshot' => 'Statistiques',
  'settings:brand_name' => 'Nom de votre marque',
  'settings:brand_name_explanation' => 'C\'est le nom que vos clients verront partout, excepté sur vos factures.',
  'settings:business_name_explanation' => 'C\'est le nom légal de votre compagnie qui sera utilisé seulement sur vos factures.',
  'settings:admin_name_explanation' => 'Par défaut, ce nom sera utilisé à la fin des courriels',
  'settings:billing_email' => 'Courriel de facturation',
  'settings:billing_email_explanation' => 'L\'adresse du destinateur utilisée lors d\'envoi de factures, de devis et de propositions.',
  'settings:notify_email_explanation' => 'L\'adresse du destinateur utilisée lors d\'envoi de commentaire, alerte et billets de support.',
  'settings:show_name_along_with_logo' => 'Affichez le nom de votre marque à côté de votre logo ?',
  'invoices:frequency' => 'Fréquence',
  'invoices:auto_send' => 'Envoyer automatiquement ?',
  'invoices:send' => 'Envoyez',
  'invoices:days_before_invoice_is_due' => 'Nombre de jour avant que la facture soit due.',
  'invoices:cannot_change_recurrences' => 'Les paramètres d\'une facture déjà récurrente à une autre ne peuvent pas être changés.',
  'email_templates:client_area_details' => 'Détails de l\'espace client',
  'settings:always_https' => 'Connexion en mode HTTPS ?',
  'settings:always_https_explanation' => 'Pancake sera toujours chargé via HTTPS. Utilisez ceci seulement si vous avez un certificat SSL installé et que vous pouvez accéder à Pancake par HTTPS.',
  'settings:remittance_slip' => 'Bordereau de paiement',
  'invoices:mail_to' => 'Envoyer à',
  'clients:send_client_area_email' => 'Envoyer les détails de l\'espace client',
  'clients:you_cannot_send' => 'Vous ne pouvez pas soummettre par courriel les détails de l\'espace client car ce dernier n\'a pas d\'adresse de courriel de configuré.',
  'invoices:discount' => 'Réduction',
  'invoices:discount_explain' => 'Ajouter % pour les pourcentages.',
  'credit_notes:edit_credit_note' => 'Modifier la note de crédit #:1',
  'credit_notes:create_credit_note' => 'Créer une note de crédit',
  'global:credit_notes' => 'Notes de crédits',
  'global:credit_note' => 'Note de crédit',
  'credit_notes:alltitle' => 'Toutes les notes de crédits',
  'credit_notes:nocredit_notesforthefilteredclient' => 'Vous n\'avez pas de notes de crédits pour :1.',
  'credit_notes:no_credit_notes' => 'Vous n\'avez pas de notes de crédit.',
  'credit_notes:create' => 'Créer une note de crédit',
  'credit_notes:no_credit_notes_body' => 'Vous n\'avez pas de note de crédit',
  'credit_notes:edit' => 'Modifier la note de crédit',
  'credit_notes:credit_note_number' => 'Note de crédit #:1',
  'credit_notes:credit_note_date' => 'Date de la note de crédit',
  'credit_notes:delete_title' => 'Supprimer cette note de crédit ?',
  'credit_notes:delete_message' => 'Êtes vous certain de supprimer cette note de crédit ?',
  'credit_notes:addedconf' => 'Vous avez ajouté une note de crédit # <strong>:1</strong>, d\'un montant total de <strong>:2</strong> (:3 avec taxes) pour :4:5.',
  'credit_notes:send_now_title' => 'Envoyer la note de crédit maintenant ?',
  'credit_notes:send_now_body' => 'Remplissez les champs ci-dessous pour envoyer une note de crédit.',
  'email_templates:new_credit_note' => 'Nouvelle note de crédit',
  'credit_notes:send_now' => 'Envoyer la note de crédit',
  'credit_notes:preview' => 'Prévisualiser la note de crédit',
  'credit_notes:duplicated' => 'Dupliquer la note de crédit #:1. Le numéro de la nouvelle cote de crédit est #:2.',
  'credit_notes:client_viewed' => ':1 à visualisé <a href=\':2\'>la note de crédit #:3</a> sur :4',
  'invoices:make_bulk_payment' => 'Effectuer des paiements multiples',
  'global:success' => 'C\'est réussi ! ',
  'clients:view' => 'Voir le client',
  'invoices:store_bulk_payment' => 'Sauvegarder des paiements multiples',
  'invoices:x_invoices' => ':1 factures',
  'invoices:amount_to_pay' => 'Montant à afficher comme étant payé',
  'invoices:bulk_payment_added' => 'Les paiements ont été ajoutés avec succès.',
  'clients:credit_balance_currently' => 'Balance de crédit (actuellement :1)',
  'clients:has_no_unpaid_invoices' => ':1 n\'a aucune facture en suspend.',
  'invoices:send_payment_notification' => 'Soumettre une notification de paiement par courriel au client ?',
  'invoices:send_bulk_payment_notification' => 'Soumettre les notifications de paiement par courriel au client ?',
  'invoices:specify_bulk_payment_details' => 'Spécifiez les détails des paiements de votre client, et sélectionnez à quelles factures correspondent les paiements.',
  'global:credit_balance' => 'Balance de crédit',
  'credit_notes:view' => 'Voir la note de crédit',
  'tickets:ticket_number' => 'Billet #:1',
  'settings:ticket_status_for_sending_invoice' => 'Statut du billet pour la facture à envoyer',
  'settings:ticket_status_for_sending_invoice_description' => 'Si il y a un billet à payer, une facture sera généré et automatique envoyé au client.',
  'settings:never_send_ticket_invoices_automatically' => '-- Ne jamais envoyer les billets de factures automatiquement --',
  'expenses:added' => 'La dépense a été ajoutée avec succès.',
  'global:error_submitting_ajax' => 'Une erreur inconnue est survenue lors de l\'envoie des données des champs. Veuillez réessayer plus tard. Si l\'erreur persiste, veuillez ouvrir un billet de support à pancakeapp.com.',
  'store:error1004' => 'Une erreur inconnue est survenue lors de l\'envoie des données des champs. Veuillez réessayer plus tard. Si l\'erreur persiste, veuillez ouvrir un billet de support à pancakeapp.com.',
  'invoices:pancake_will_automatically_change_is_viewable' => 'Ceci changera automatiquement à \'Oui\' quand la facture sera envoyée au client.',
  'global:incorrect_login' => 'La combinaison du nom d\'utilisteur et du mot de passe que vous avez entré est invalide.',
  'settings:hide_tax_column' => 'Cacher la colonne des taxes',
  'settings:hide_tax_column_explanation' => 'Ceci cachera la colonne des taxes sur les factures qui n\'ont pas de détails de taxes.',
  'tickets:not_yet_generated' => 'Cette facture n\'est pas encore générée',
  'tickets:invoice_will_be_generated' => 'Une :1 facture pour ce billet sera générée lorsque le statut du billet changera pour ":2".',
  'global:accepted' => 'Accepté',
  'global:rejected' => 'Rejeté',
  'global:unanswered' => 'Sans réponse',
  'estimates:accepted' => 'Devis acceptés',
  'estimates:rejected' => 'Devis rejetés',
  'estimates:unanswered' => 'Devis sans réponse',
  'emailtemplates:content' => 'Contenu du courriel',
  'global:triennially' => 'Tous les trois ans',
  'invoices:send_to_client' => 'Envoyer la facture au client',
  'estimates:send_to_client' => 'Envoyer le devis au client',
  'global:beforeunload' => 'Vous êtes sur le point de quitter cette page. Si vous avez entré des données, ceux-ci seront perdus.',
  'global:appendtoproject' => 'Convertir en tâches pour ":1"',
  'estimates:appended' => 'Convertir le devis #:1 en tâches pour ":2".',
  'items:percentage_discount' => 'Rabais (%)',
  'items:fixed_discount' => 'Rabais (:1)',
  'invoices:discount_percentage' => 'Rabais (:1%)',
  'invoices:sub_total_after_discounts' => 'Sous-total après les tabais',
  'clients:tax_registration_number' => ':1 numéro',
  'clients:add_custom_field' => 'Ajouter un nouveau champ personnalisé',
  'clients:tax_numbers' => 'Numéros de taxes du client',
  'clients:custom_fields' => 'Champ personnalisé',
  'expenses:category_added' => 'La catégorie de dépense a été créé avec succès.',
  'clients:update_balance' => 'Mettre à jour la balance de crédit',
  'clients:balance_updated' => 'La balance de crédit a été mise à jour avec succès.',
  'clients:what_do_you_want_to_do' => 'Qu\'est-ce que voulez faire ?',
  'clients:save_balance_alteration' => 'Enregistrer le changement de balance',
  'clients:no_amount_specified' => 'Vous n\'avez pas spécifié de montant.',
  'expenses:attach_receipt' => 'Inclure le reçu (Taille maximale: :1)',
  'expenses:no_project_business_expense' => 'Dépense de l\'entreprise',
  'expenses:expense_date' => 'Date',
  'expenses:receipt' => 'Reçu',
  'expenses:no_receipt' => 'Aucun reçu',
  'expenses:edited' => 'La dépense a été modifiée avec succès.',
  'expenses:expense_receipts' => 'Reçus des dépenses',
  'reports:payments' => 'Paiements',
  'reports:verb_created' => 'Créé',
  'reports:verb_paid' => 'Payé',
  'reports:verb_from_to' => ':1 de :2 à :3',
  'reports:amount_paid' => 'Montant du paiement',
  'dashboard:upcoming_invoices' => 'Facture(s) échue(s)',
  'dashboard:there_are_no_upcoming_invoices' => 'Aucune facture à échéance à afficher.',
  'error:cannot_send_error_details' => 'Vous ne pouvez pas envoyer le détails des erreurs au support de Pancake parce que vous n\'êtes pas connecté.',
  'error:unknown_error_reporting' => 'Une erreur est survenue, veuillez soumettre cette erreur manuellement.',
  'error:sending_details' => 'Envoie des détails en cours...',
  'error:response_will_be_sent_to_email' => 'Vous serez alerté par courriel à {email}.',
  'settings:errors_and_diagnostics' => 'Erreurs et diagnostique',
  'error:already_reported' => 'Cette erreur a déjà été soumis au support de Pancake.',
  'error:title' => 'Erreur inconnue',
  'error:subtitle' => 'Une erreur inconnue est survenue.',
  'error:not_logged_in_intro' => 'Ces erreurs sont enregistrées automatiquement.',
  'error:not_logged_in_extra' => 'Si le problème persiste, veuillez contacter :1.',
  'error:logged_in_intro' => 'Ces erreurs sont enregistrées dans l\'admin, sous Paramètres > Erreurs et diagnostiques\'.',
  'error:logged_in_extra' => 'Cliquez ici pour soumettre un billet de support avec les détails de l\'erreur au support de Pancake.',
  'error:no_logged_errors' => 'Vous n\'avez aucune erreur d\'enregistrée.',
  'errors:subject' => 'Titre de l\'erreur',
  'errors:report' => 'Soumettre l\'erreur',
  'errors:number_of_occurrences' => '# d\'occurences',
  'global:errors' => 'Erreurs',
  'settings:error_reported' => 'Erreur reportée',
  'settings:report_error' => 'Soumettre l\'erreur',
  'settings:delete_error' => 'Supprimer l\'erreur',
  'global:once' => 'à une reprise',
  'global:twice' => 'à deux reprises',
  'global:x_times' => ':1 fois',
  'global:occurred_times' => 'Survenu :1',
  'settings:view_error_details' => 'Voir les détails de l\'erreur',
  'error:deleting' => 'Supression...',
  'error:reporting' => 'Envoi de l\'erreur...',
  'clients:noclientbodyfiltered' => 'Aucun nom de vos clients débute par \':1\'.',
  'tickets:archive' => 'Archive',
  'tickets:unarchive' => 'Restaurer',
  'projects:unarchive_proj' => 'Restaurer le projet',
  'invoices:lastreoccurrence' => 'Dernière récurrence: :1',
  'projects:role_view' => 'Voir',
  'projects:role_create' => 'Créer',
  'projects:role_edit' => 'Modifier',
  'projects:role_delete' => 'Supprimer',
  'projects:role_add_task' => 'Ajouter une tâche',
  'projects:role_edit_task' => 'Éditer une tâche',
  'projects:role_delete_task' => 'Supprimer une tâche',
  'projects:role_add_milestone' => 'Ajouter une étape',
  'projects:role_edit_milestone' => 'Modifier une étape',
  'projects:role_delete_milestone' => 'Supprimer une étape',
  'projects:role_track_time' => 'Gestion du temps',
  'projects.title' => 'Projets',
  'projects.create.title' => 'Créer un projet',
  'projects.edit.title' => 'Modifier projet',
  'projects.label.name' => 'Nom :',
  'projects.label.client' => 'Client:',
  'projects.label.due_date' => 'Livrable le :',
  'projects.label.rate' => 'Taux horaire :',
  'projects.label.description' => 'Description:',
  'projects.label.is_viewable' => 'Disponible dans l\'espace client ?',
  'projects.button.create' => 'Créer le projet &rarr;',
  'projects.create.succeeded' => 'Le projet à été créé !',
  'projects.button.edit' => 'Modifier le projet &rarr;',
  'projects.button.delete' => 'Supprimer le projet &rarr;',
  'projects.update.succeeded' => 'Le projet a été modifié !',
  'projects.delete.title' => 'Voulez vous vraiment supprimer ce projet ?',
  'times.title' => 'Temps',
  'times.create.title' => 'Ajouter du temps',
  'times.label.start_time' => 'Heure de début:',
  'times.label.end_time' => 'Heure de fin:',
  'times.label.date' => 'Date:',
  'times.label.task_id' => 'Tâche:',
  'times.label.note' => 'Note :',
  'times.label.notes' => 'Notes :',
  'times.button.create' => 'Ajouter du temps &rarr;',
  'times.create.succeeded' => 'Le temps a été ajouté !',
  'times.edit.succeeded' => 'Le temps a été modifié avec succès !',
  'global:estimates_unsent' => 'Non envoyé',
  'error:not_enough_disk_space' => 'Espace disque insuffisant',
  'error:cant_send_email' => 'Impossible d\'envoyer un courriel',
  'error:not_enough_disk_space_explanation' => 'Votre serveur de base de données (:1) ne possède pas d\'espace disque suffisant.',
  'error:you_cannot_report_this_error' => 'Vous ne pouvez pas signaler cette erreur au support Pancake parce qu\'il y a une erreur avec votre serveur. Veuillez contacter l\'administrateur de votre serveur à propos de ce problème. Code d\'erreur :',
  'error:not_enough_disk_space_solutions' => 'Si vous avez accès à votre base de données en mode root, supprimez le dossier /tmp. Si cela ne fonctionne pas, veuillez vérifier l\'espace disque disponible sur votre serveur de base de données.',
  'error:cant_send_email_explanation' => 'Vous avez spécifié que vous désirer utiliser Sendmail (:1) pour envoyer des courriels. Cette opération est présentement impossible à réaliser. Vérifiez que le chemin d\'accès et bien entré.',
  'error:email_settings_not_valid' => 'Vos paramètres courriel ne sont pas valide.',
  'error:cant_send_email_solutions' => 'Si vous avez accès à votre base de données en mode root, veuillez vérifier que la fonction <code>sendmail</code> est bien installée.',
  'error:server_error' => 'Une erreur est survenue sur le serveur',
  'error:xcache_extension_broken' => 'Votre serveur semble avoir un problème avec l\'extension XCache.',
  'error:xcache_extension_broken_explanation' => 'Une erreur est survenue pendant que votre serveur utilisait XCache. Ceci n\'est pas relié à Pancake mais ceci prévient Pancake de bien fonctionner.',
  'error:permissions_not_valid' => 'Il y a un problème de permission de fichier sur votre serveur.',
  'error:no_tmp_dir_permissions_explanation' => 'Votre serveur ne permet pas à Pancake de créer des fichiers temporaires dans <code>:1</code>.',
  'error:no_tmp_dir_permissions_solutions' => 'Si vous avez l\'accès root de votre serveur, vous pouvez changer le paramètre <code>open_basedir</code> dans votre fichier php.ini pour que le <code>:1</code> soit inclu dans la liste des dossiers acceptés.',
  'error:cant_php_mail_explanation' => 'Vous avez spécifié vouloir utiliser PHP mail() pour soumettre vos courriels mais cette méthode ne fonctionne pas correctement sur votre serveur. Cette méthode requiert aucune configuration de votre part mais n\'est pas recommandé puisque les serveurs de courriels ne peuvent vérifier l\'expéditeur. Certain de vos courriels peuvent se retrouver signalés en tant que spam. Changez vos paramètres de votre serveur de courriels dans votre espace d\'administration sous \'Paramètres > Courriels\' pour utiliser les options SMTP ou si vous ne pouvez pas, utilisez l\'option Sendmail comme dernier recours. Si aucune de ces méthodes ne fonctionnent, vous devrez contacter votre administrateur système.',
  'invoices:see_payment_schedule_below' => 'Voyez les modalités de paiement ci-dessous',
  'invoices:see_payment_schedule' => 'Voir l\'échéancier des paiements',
  'partial:partialpayments' => 'Échéancier de paiement',
  'partial:amountlefttobeadded' => 'Montant restant à ajouter à l\'échéancier de paiement',
  'partial:amounttoobig' => 'Montant devant être retiré de l\'échéancier de paiement',
  'partial:noamountneeded' => 'Votre échéancier de paiement est complet.',
  'partial:wrongtotal' => 'Le total des montants de votre échéancier de paiement ne concordent pas au total de votre facture.',
  'partial:problemsaving' => 'Une erreur est survenue lors de l\'enregistrement de votre échéancier de paiement. Veuillez réessayer.',
  'partial:wrongtotalbutsaved' => 'Le total des montants de votre échéancier de paiement ne concordent pas au total de votre facture.<br />Les changements de effectués sur votre facture ont été sauvegardés mais vous devez corriger votre échéancier de paiement.',
  'partial:problemsavingbutsaved' => 'Une erreur est survenue lors de l\'enregistrement de votre calendrier de paiement. Veuillez réessayer.<br />Les changements de effectués sur votre facture ont été sauvegardés mais vous devez corriger votre échéancier de paiement.',
  'partial:addanother' => 'Ajouter une nouvelle partie à l\'échéancier de paiement',
  'partial:disabledforrecurring' => 'Les factures récurrentes sont limités à un seul paiement',
  'partial:partpaidthanks' => 'Cette partie de votre échéancier de paiement à été payé. Merci.',
  'error:page_not_found' => 'Page non trouvée',
  'error:page_does_not_exist' => 'La page que vous tentez de consulter n\'existe pas.',
  'error:page_does_not_exist_explanation' => 'Vous tentez d\'accéder :1, mais cette page n\'existe pas. Si cette erreur n\'est pas supposée s\'afficher, vous pouvez la reporter au support de Pancake. Vous le trouverez dans \'Paramètres > Erreurs et diagnostiques\'.',
  'settings:importedcredit_notes' => ':1 notes de crédit importés avec succès.',
  'expenses:supplier_added' => 'Le fournisseur à été ajouté avec succès.',
  'reports:per_payment_method' => 'par méthode de paiement',
  'gateways:just_for_logging' => 'Note : cette méthode de paiement n\'affecte en aucun cas les factures.<br />Cette dernière sert à savoir quel paiement vous recevez par :1.',
  'projects:no_data_provided' => 'Vous n\'avez entré aucune information pour la création du projet depuis un modèle existant.',
  'projects:invalid_template' => 'Vous n\'avez sélectionné aucun modèle de projet valide.',
  'settings:test_email_subject' => 'Ceci est un courriel d\'essai.',
  'settings:test_email_message' => 'Ceci est un courriel d\'essai. Ci vous avez reçu ceci, cela signifie que les courriels fonctionnent dans Pancake.',
  'settings:send_test_email' => 'Envoyer un courriel d\'essai',
  'settings:sending' => 'Envoi de courriel en cours...',
  'settings:test_email_sent' => 'Envoyé à :1 avec succès!',
  'settings:test_email_error_header' => 'Erreur lors de l\'envoi du courriel d\'essai',
  'settings:test_email_error' => 'Une erreur est survenue lors de l\'envoi du courriel d\'essai :<br /><br />:1<br /><br />Please make sure the details you entered are correct. If you\'re using SMTP, make sure the port you\'re trying to use is open in your server\'s firewall.',
  'settings:test_email_connection_error' => 'Votre serveur ne peut se connecter à :1 sur le port :2. Veuillez contacter votre administrateur réseau pour qu\'il autorise ce port dans le coupe-feu de votre serveur.<br /><br />Le message d\'erreur est :<br /><br />:3',
  'invoices:all_unpaid' => 'Toutes factures impayées',
  'items:select_flat_rate' => 'Taux fixe',
  'kitchen:no_tickets_created' => 'Aucun billet créé.',
  'kitchen:responses' => 'Réponses',
  'kitchen:x_responses' => ':1 réponses',
  'projects:add_new_task' => 'Ajouter une nouvelle tâche',
  'projects:delete_project_template' => 'Supprimer le modèle du projet',
  'expenses:supplier_edited' => 'Le fournisseur a été modifié avec succès.',
  'global:show_hide_deleted' => 'Afficher / Cacher',
  'expenses:supplier_name' => 'Nom du fournisseur',
  'expenses:category_name' => 'Nom de la catégorie',
  'expenses:category_edited' => 'La catégorie a été modifiée avec succès.',
  'expenses:before_you_can_add_expenses' => 'Avant de pouvoir créer des dépenses, vous devez créer des :1 et des :2.',
  'reminders:no_due_date' => 'Aucune date due',
  'reminders:x_days_past_due' => ':1 jours passé la date due',
  'search:results_for_x' => 'Résultats de recherches pour ":1"',
  'search:one_matching_result' => '1 résultat',
  'search:x_matching_results' => ':1 résultats',
  'global:project_expense' => 'Dépense',
  'global:project_task' => 'Tâche',
  'global:ticket' => 'Billet',
  'tickets:added' => 'Le billet a été créé avec succès.',
  'tickets:replied' => 'La réponse du billet a été sauvegardé avec succès.',
  'tickets:user_updated_ticket' => ':1 a mis à jour le billet pour :2 le :3',
  'global:reply' => 'Répondre',
  'global:attach_file' => 'Fichier attaché (Taille maximale: :1)',
  'global:download_csv' => 'Télécharger le CSV',
  'reports:uncollected' => 'Non collecté',
  'reports:collected' => 'Collecté',
  'clients:filter_clients' => 'Filter les clients',
  'users:deactivate' => 'Désactiver',
  'users:activate' => 'Activer',
  'global:group' => 'Groupe',
  'users:edit_user' => 'Modifier l\'utilisateur',
  'users:please_enter_information' => 'Veuillez entrer les information de l\'utilisateur ci-dessous.',
  'users:confirm_password' => 'Confirmer le mot de passe',
  'invoices:not_associated_with_a_project' => '-- Aucune association avec un projet --',
  'global:by_x_with_time' => 'Par :1, :2.',
  'tasks:add_notes' => 'Ajouter une note',
  'tasks:complete_this_task' => 'Completer cette tâche',
  'tasks:task_notes' => 'Notes de la tâche',
  'tasks:discuss_task' => 'Discussion de la tâche',
  'tickets:leave_a_response' => 'Répondre',
  'tickets:active_tickets' => 'Billets actifs',
  'projects:rate_type' => 'Type de taux',
  'projects:hourly_rate' => 'Taux horaire',
  'global:bcc_was_sent_to' => 'Ce courriel a été envoyé à :1 le :2.',
  'global:server_default' => 'Paramètres par défaut (Non recommandé)',
  'error:fixed_in_version' => 'Ce problème a été corrigé dans Pancake {version}. Veuillez mettre à jour votre version de Pancake si ce n\'est pas déjà fait.',
  'error:no_user_found' => 'Votre licence n\'est pas associée avec aucun utilisateur sur pancakeapp.com donc votre erreur n\'a pu être envoyé. Envoyez un courriel à support@pancakeapp.com si vous éprouvez des problèmes.',
  'error:already_being_dealt_with' => 'Ce problème a déjà été reporté par quelqu\'un. Nous travaillons à résoudre ce problème le plus rapidement possible.',
  'error:php_outdated' => 'La version de PHP que vous utilisez est périmée.',
  'error:using_php_53' => 'Vous utilisez PHP 5.3, qui n\'est plus à jour depuis juillet 2013 et n\'est plus pris en charge par le groupe PHP.',
  'error:pancake_will_stop_supporting_it' => 'Pancake peut cesser de le supporter à tout moment.',
  'error:using_php_54' => 'Vous utilisez PHP 5.4, qui n\'est plus à jour depuis septembre 2014 et n\'est plus supporté par le groupe PHP.',
  'error:why_update' => 'Si vous désirez conserver cette version de PHP, certaines fonctionalités ne seront pas disponibles.',
  'error:upgrade_php' => 'Vous devriez changer votre version de PHP à 5.5 au minimum. Si vous ne savez pas comment faire, contactez votre administrateur réseau.',
  'error:scan_pancake' => 'Vérifier votre installation Pancake pour des problèmes reliés aux fichiers',
  'error:scan_pancake_explanation' => 'Certains problèmes peuvent survenir suite à une mauvaise mise à jour ou à des permissions de fichiers. Utilisez ceci pour vérifier votre installation Pancake.',
  'error:scanning' => 'Veuillez patienter ...',
  'error:unknown_error_scanning' => 'Une erreur inconnue est survenue.',
  'error:scan' => 'Inspection',
  'error:scan_result_success' => 'Pancake est en parfaite condition et fonctionne à merveille.',
  'error:scan_result_failure_deleted_one' => ':1 fichier n\'existe pas',
  'error:scan_result_failure_deleted_other' => ':1 fichiers n\'existent pas',
  'error:scan_result_failure_modified_one' => ':1 fichier a été modifié',
  'error:scan_result_failure_modified_other' => ':1 fichiers ont été modifiés',
  'error:scan_result_failure_heading' => 'Il semble y avoir un problème avec vos fichiers Pancake.',
  'error:scan_result_failure_how_to_fix' => 'Pour résoudre ces problèmes, vous devrez mettre à jour vos fichiers Pancake manuellement.',
  'error:click_here_for_instructions' => 'Cliquez ici pour les instructions',
  'error:and_x_others' => '... et :1 autre.',
  'global:archive' => 'Archive',
  'global:archived' => 'Archivé',
  'global:restore' => 'Restaurer',
  'proposals:restored' => 'Vous avez restauré la proposition #:1 avec succès.',
  'proposals:archived' => 'Vous avez archivé la proposition #:1 avec succès.',
  'proposals:list_unanswered' => 'Propositions sans réponse',
  'invoices:restored' => 'Vous avez restauré la facture #:1 avec succès.',
  'estimates:archived' => 'Vous avez archivé l\'estimation #:1 avec succès.',
  'invoices:credit_notes_archived' => 'Notes de crédit archivées',
  'credit_notes:archived' => 'Vous avez archivé la note de crédit #:1 avec succès.',
  'estimates:restored' => 'Vous avez restauré l\'estimation #:1 avec succès.',
  'credit_notes:restored' => 'Vous avez restauré la note de crédit #:1 avec succès.',
  'proposals:list_rejected' => 'Offres rejetées',
  'proposals:list_all' => 'Toutes les offres.',
  'proposals:list_archived' => 'Propositions archivées',
  'invoices:invoices_archived' => 'Factures archivées',
  'invoices:estimates_archived' => 'Estimations archivées',
  'invoices:archived' => 'Vous avez archivé la facture #:1 avec succès.',
  'proposals:list_accepted' => 'Propositions acceptées',
  'invoices:willreoccurin' => 'Cette facture se reproduira au  :1.',
  'estimates:estimates_unsent' => 'Devis non envoyés',
  'tickets:invoice_for_ticket' => 'Billet # :1 - :2',
  'tickets:link_to_ticket' => 'Lien vers le billet : :1',
  'dashboard:outstanding_invoices' => 'Factures non payées',
  'dashboard:view_all_outstanding_invoices' => 'Voir toutes les factures non payées',
  'expenses:missing_category' => 'Vous n\'avez pas sélectionné de catégorie.',
  'expenses:missing_supplier' => 'Vous n\'avez pas sélectionné de fournisseur.',
  'error:update_system' => 'Erreur lors de la mise à jour',
  'error:update_system_solutions' => 'La mise à jour n\'a pas pu se terminer, et il se peut que votre Pancake soit maintenant dans un état de mise à jour partielle, ce qui peut causer des erreurs. Vous aurez besoin de mettre à jour manuellement vos fichiers Pancake pour résoudre le problème. <br/><br/> :1 <br/><br/> Ces erreurs peuvent se produire en raison d\'un problème avec les permissions de fichiers. Si Pancake n\'a pas accès en écriture à tous ses fichiers, il est incapable de se mettre à jour correctement. Dans la plupart des serveurs, cela est géré automatiquement, mais un très petit nombre de serveurs pourrait nécessiter une intervention manuelle.',
  'error:update_system_cannot_update_file' => 'Pancake n\'a pu modifier un ou plusieurs de ses fichiers lors de la mise à jour.',
  'error:update_system_cannot_update' => 'Pancake n\'a pas pu télécharger la mise à jour correctement.',
  'error:update_without_ftp' => 'Si vous n\'avez pas d\'accès  FTP (ou ne voulez pas utiliser FTP), mais avec un accès SSH à votre Pancake, <a class="blue-btn" href="https://www.pancakeapp.com/faq/update-without-ftp" target="_blank">cliquez ici</a> pour apprendre comment mettre à jour sans FTP.',
  'proposals:missing_client' => 'Vous n\'avez pas sélectionné de client.',
  'gateways:direct_debit' => 'Débit direct',
  'error:no_permissions_explanation' => 'Pancake n\'a pas l\'autorisation de créer des fichiers dans <code>:1</code>.',
  'error:no_permissions_solutions' => 'Vous pouvez résoudre ce problème en rendant le dossier accessible en écriture. Généralement, cela se fait à l\'aide de CHMOD 0777, mais il peut y avoir d\'autres façons pour vous de le faire (par exemple via le panneau de contrôle de votre hébergeur web).',
  'error:you_cannot_report_this_non_server_error' => 'Vous ne pouvez pas signaler ce problème au Support Pancake car ce n\'est pas un problème lié à Pancake.',
  'settings:currency_format' => 'Format monétaire',
  'settings:decimal_places' => ':1  décimales',
  'settings:no_notify_email' => 'Vous ne possédez pas d\'adresse courriel pour l\' <a href=":1">identité de votre entreprise</a>.<br/>Pancake n\'est pas en mesure d\'envoyer un courriel.',
  'settings:add_another_business' => 'Ajouter une autre entreprise',
  'global:auto_send_needs_pancake_cron_job' => 'Pour envoyer automatiquement les factures, vous devez configurer le <a href="https://www.pancakeapp.com/documentation/cron" target="_blank">Pancake Cron</a>.',
  'settings:always_autosend' => 'Envoi automatique de factures par défaut',
  'invoice:description' => 'Description',
  'invoices:auto_charge' => 'Facturer le client automatiquement',
  'invoices:pancake_will_charge_when_invoice_is_due' => 'Pancake débitera automatiquement ce client lorsque la facture sera due, en utilisant ses informations de paiement enregistrées.',
  'global:or' => 'ou',
  'invoices:charge_when_due' => 'Facturer selon le dû',
  'invoices:could_not_auto_charge' => 'Pancake n\'a pas réussi à facturer automatiquement votre client. Votre client devra payer la facture #:1 manuellement.',
  'invoices:auto_charged' => 'Votre client a été débité pour la facture #:1. La facture est maintenant payée.',
  'settings:gmail_setup_successfully' => 'Vous avez connecté avec succès votre Pancake avec votre compte Gmail !',
  'credit_notes:messageupdated' => 'La note de crédit a été mise à jour !',

  # Begin v4.12.0 changes
  "invoices:pancake_will_charge_when_invoice_is_due" => "Pancake chargera automatiquement ce client lorsque la facture sera dûe grâce à leurs détails de paiement enregistrés.",
  "invoices:pancake_cannot_auto_charge" => "Il n'y pas de détails de paiement pour ce client. Le client devra payer au minimum une fois avec Stripe afin que les détails de paiement s'enregistrent.",

  "settings:pancake_uses_our_servers" => "Note : Pancake utilise les serveurs de Pancake afin que la permission de connexion ne s'expire pas.<br />Nous n'enregistrons pas d'information. Si vous avez votre propre compte développeur de Google, vous pouvez <a target='_blank' href='https://www.pancakeapp.com/faq/google-oauth'>utiliser votre propre serveur</a>.",
  "settings:you_are_signed_in" => "Vous êtes connecté comme :1.<br />Cliquez sur le bouton plus bas si vous voulez mettre à jour vos détails ou pour utiliser un autre compte.",
  "settings:you_are_using_old_auth" => "Pancake envoie des courriels grâce à la méthode :1 votre courriel et mot de passe.<br />Cliquez sur le bouton plus bas pour sécuriser votre méthode d'envoie courriel avec Gmail.",
  "invoices:send_now" => "Envoyer la facture",
  'credit_notes:resend' => 'Envoyer la note de crédit de nouveau',
  "global:support" => "Aide / Assistance",
  "settings:filesystem" => "Où voulez-vous enregistrer les fichiers",
  "settings:filesystem_local" => "Dossier de téléversement",
  "filesystem:s3_access_key" => "Clé d'accès",
  "filesystem:s3_secret_key" => "Clé secret",
  "filesystem:s3_prefix" => "Dossier (optionel)",
  "filesystem:s3_bucket" => "S3 Bucket",
  "invoices:amount_due" => "Montant dû",
  "invoices:due_date" => "Dû pour le",
  "settings:filesystem_explain" => "Attention: Si vous changez ces paramètres, Pancake copiera tous les fichiers dans le nouvel emplacement de stockage pour vous. Vous n'avez aucune manipulation supplémentaire à effectuer.",
  # End v4.12.0 changes
  
  # Begin v4.12.1 changes
  "error:using_old_php" => "Vous utlisez PHP :1, qui est déprécié depuis :2 et n'est plus supporté par le groupe PHP.",
  # End v4.12.1 changes
  
  # Begin v4.12.7 changes
  "settings:last_cron_run_datetime" => "Dernière exécution: :1",
  # End v4.12.7 changes
  
  # Begin v4.12.9 changes
  "settings:hijacked_error" => '<div class="diagnostic-error"><h4>Votre serveur vous joue des tours!</h4><p>Vous tentiez de vous connecter à :1, mais votre serveur s\'est connecté à :2.<br /><br />Ceci est une brêche de sécurité importante car votre nom d\'utilisateur, votre mot de passe et votre adresse courriel ont été envoyés à un serveur de messagerie différent du vôtre.<br /><br />Veuillez contacter l\'administrateur de votre serveur à propos de cela.</p></div>',
  # End v4.12.9 changes
  
  # Begin v4.12.13 changes
  "invoices:edit_does_not_exist" => 'La facture que vous tentez de modifer est inexistante.',
  # End v4.12.13 changes
  
  # Begin v4.12.14 changes
  "settings:importedexpenses" => ':1 dépenses importées avec succès.',
  "projects:is_timesheet_viewable" => "Afficher la feuille de temps dans la zone client?",
  "tasks:is_timesheet_viewable" => "Afficher la liste des tâches dans la zone client?",
  # End v4.12.14 changes
  
  # Begin v4.12.15 changes
  "notifications:mark_all_as_read" => "Marquer tous comme lues",
  'notifications:new_comment' => ':1 a commenté sur <a href=":2">:3</a> le :4',
  # End v4.12.15 changes
  
  # Begin v4.12.16 changes
  "invoices:unsent_recurrences" => "Non envoyées (factures récurrentes)",
  "invoices:unsent_not_recurrences" => "Non envoyées (factures non récurentes)",
  "discussions:does_not_exist" => "L'item que vous tentez d'accéder n'existe pas.",
  "discussions:private_commented_successfully" => "Votre commentaire privé a été publié avec succès. Le client ne pourra le voir.",
  "discussions:public_commented_successfully" => "Votre commentaire a été publié avec succès. Une notification par courriel sera envoyé au client.",
  "discussions:discussion_area" => "Zone de discussion",
  # End v4.12.16 changes
  
  # Begin v4.12.18 changes
  "projects:project_invoices" => "Factures de projets",
  "projects:project_estimates" => "Devis de projets",
  'global:upload_ini_size' => 'Le fichier que vous téléversé excede la taille imposé par votre serveur web (:1).',
  "discussions:message_cannot_be_empty" => "Votre commentaire ne peut être vide.",
  "global:change_date_range" => "Modifier la plage horaire",
  "timesheet:rounded" => "Arrondi",
   # End v4.12.18 changes
  
   # Begin v4.12.19 changes
   "projects:deleted" => "Projet supprimé avec succès!",
   'tickets:edited' => 'Billet :1 modifié avec succès!',
   # End v4.12.19 changes
  
   # Begin v4.12.20 changes
   "global:x_hours" => ":1 heures",
   "global:one_hour" => ":1 heure",
   # End v4.12.20 changes
  
   # Begin v4.12.21 changes
   "global:couldnotsendemail" => "Pancake n'a pu envoyer le courriel.<br />Allez dans les paramètres > Courriels et vérifiez vos paramètres courriels.",
   "settings:gmail_access_denied" => "Vous avez bloqué l'accès Gmail à votre installation Pancake pour l'envoi de courriel.",
   'notifications:new_ticket' => ':1 créé <a href=":2">:3</a> le :4',
   'notifications:responded_ticket' => ':1 a répondu à <a href=":2">:3</a> on :4',
   'notifications:updated_status_ticket' => ':1 a changé le statut de <a href=":2">:3</a> à <strong>:5</strong> le :4',
   'tickets:ticket_title' => "Billet #:1 - :2",
   # End v4.12.21 changes
   
   # Begin v4.12.22 changes
   "invoices:unpaid_recurrences" => "Factures impayées (récurentes)",
   "invoices:unpaid_not_recurrences" => "Factures impayées (non récurente)",
   # End v4.12.22 changes
   
   # Begin v4.12.24 changes
   "invoices:amount_including_surcharge" => ":1 incluant une surcharge de :2",
   # End v4.12.24 changes
  
  # Begin v4.12.27 changes
    "invoices:delete_does_not_exist" => "La facture que vous tentez de supprimer n'est pas disponible.",
    "invoices:select_a_gateway" => "Vous devez spécifier une méthode de paiement.",
    "discussions:are_you_sure_delete" => "Désirez-vous vraiment supprimer ce commentaire?",
    "discussions:deleted" => "Le commentaire a été supprimé.",
    "discussions:edited" => "Le commentaire a été modifié avec succès.",
    "projects:back_to_project" => "Retour au projet",
    # End v4.12.27 changes
  
    # Begin v4.13.0 changes
    "reports:all_business_identities" => "Toutes les identitées d'entreprises",
    "clients:default_currency" => "Devise par défaut",
    "clients:default_currency_explanation" => "Sera utilisé par défaut pour toutes les nouvelles factures, projets et devis pour ce client.",
    "paypalpro:paypalpro" => "Paiments PayPal Pro",
    "gateways:surcharge_percentage" => "Frais de transaction (%)",
    "gateways:surcharge_percentage_explanation" => "Sera ajouté automatiquement au paiement effectué avec cette plateforme de paiement.",
    "gateways:surcharge_invoice" => ":1 Surcharge",
    # End v4.13.0 changes
  
    # Begin v4.13.4 changes
    "gateways:surcharge_invoice" => ":1 de surcharge pour la facture #:2",
    "gateways:direct_deposit" => "Dépôt direct",
    # End v4.13.4 changes
  
    # Begin v4.13.6 changes
    "items:period" => "Période",
    "items:period_day" => "Jours",
    "items:period_week" => "Semaines",
    "items:period_month" => "Mois",
    "items:period_year" => "Années",
    'credit_notes:added' => '<strong>Félicitation!</strong> La note de crédit a été ajoutée.',
    # End v4.13.6 changes
  
     # Begin v4.13.7 changes
    "global:upload_not_allowed" => "La mise à jour du fichier ':1' n'est pas permise. Si vous devez charger ce type de fichier, veuillez le compresser en format .zip ou tout autre type de fichier archivé.",
    "settings:pdf_footer_contents" => "Contenu du pied de page du PDF",
    "settings:pdf_footer_contents_explanation" => "Ceci s'affichera sur chaque page des fichiers PDF pour les factures, devis et notes de crédits.<br />Vous pouvez utiliser <strong>{{page}}</strong> et <strong>{{pages}}</strong> pour afficher la page utilisé et le nombre du total de pages.",
    # End v4.13.7 changes
 
  # Begin v4.13.8 changes
    "settings:what_variables_can_i_use" => "Quelles variables puis-je utiliser?",
    # End v4.13.8 changes

);
/** End of file: pancake_lang.php **/
