<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Group model
 *
 * @author Phil Sturgeon - PyroCMS Dev Team
 * @package PyroCMS
 * @subpackage Groups module
 * @category Modules
 *
 */
class Group_m extends Pancake_Model
{
	public $validate = array(
		array(
			'field' => 'name',
			'label' => 'lang:groups:name',
			'rules' => 'trim|required|max_length[100]'
		),
		array(
			'field' => 'description',
			'label' => 'lang:groups:description',
			'rules' => 'trim|required|max_length[250]'
		),
	);
	
	/**
	 * Check a rule based on it's role
	 *
	 * @access public
	 * @param string $role The role
	 * @param array $location
	 * @return mixed
	 */
	public function check_rule_by_role($role, $location)
	{
		// No more checking to do, admins win
		if ($role == 1)
		{
			return TRUE;
		}

		// Check the rule based on whatever parts of the location we have
		if (isset($location['module']) )
		{
			 $this->db->where('(module = "'.$location['module'].'" or module = "*")');
		}

		if (isset($location['controller']) )
		{
			 $this->db->where('(controller = "'.$location['controller'].'" or controller = "*")');
		}

		if (isset($location['method']) )
		{
			 $this->db->where('(method = "'.$location['method'].'" or method = "*")');
		}

		// Check which kind of user?
		$this->db->where('g.id', $role);

		$this->db->from('permissions p');
		$this->db->join('groups as g', 'g.id = p.group_id');

		$query = $this->db->get();

		return $query->num_rows() > 0;
	}

	/**
	 * Return an array of groups
	 *
	 * @access public
	 * @param array $params Optional parameters
	 * @return array
	 */
	public function get_all($params = array())
	{
		if (isset($params['except']) )
		{
			$this->db->where_not_in('name', $params['except']);
		}

		return parent::get_all();
	}

	/**
	 * Add a group
	 *
	 * @access public
	 * @param array $input The data to insert
	 * @return array
	 */
	public function insert($input = array())
	{
		return parent::insert(array(
			'name'			=> $input['name'],
			'description'	=> $input['description']
		));
	}

	/**
	 * Update a group
	 *
	 * @access public
	 * @param int $id The ID of the role
	 * @param array $input The data to update
	 * @return array
	 */
	public function update($id = 0, $input = array())
	{
		return parent::update($id, array(
			'name'			=> $input['name'],
			'description'	=> $input['description']
		));
	}

	/**
	 * Delete a group
	 *
	 * @access public
	 * @param int $id The ID of the group to delete
	 * @return
	 */
	public function delete($id = 0)
	{
		$this->load->model('users/user_m');
		
		// don't delete the group if there are still users assigned to it
		if ($this->user_m->count_by(array('group_id' => $id)) > 0)
		{
			return FALSE;
		}

		// Dont let them delete the "admin" group or the "user" group.
		// The interface does not have a delete button for these, this is just insurance
		$this->db->where_not_in('name', array('user', 'admin'));

		return parent::delete($id);
	}
}